<?php

namespace App\Http\Controllers\client;

use App\Models\User;
use App\Models\panel\address_home;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class addressHomeController extends Controller
{
    
    public function addAddressHome(){
        $id_user = \Auth::user() -> id;
        return view('client.addresshome.addAddressHome');
    }

    public function editAddressHome($id){
        $id_user = \Auth::user() -> id;
        $AddressHome = address_home::find($id);
        if($AddressHome -> client_id != $id_user){
            redirect()->to('404')->send();
        }
        return view('client.addresshome.editAddressHome',compact('AddressHome'));
    }
    
    public function allAddressHome(){
        $id_user = \Auth::user() -> id;
        $AddressHome = address_home::orderBy('created_at','desc')->where('client_id',$id_user)->paginate(10);
        return view('client.addresshome.allAddressHome',compact('AddressHome'));
    }


    public function create(Request $request){

        $request->validate([
            'title' => 'required|string',
            'name_receiver' => 'required|string',
            'phone_receiver' => 'required|numeric',
            'postal_code' => 'required|numeric',
            'address' => 'nullable|string',
        ]);
        $id_user = \Auth::user() -> id;
        $address_home = new address_home();
        $address_home -> title = $request -> title ;
        $address_home -> name_receiver = $request -> name_receiver ;
        $address_home -> phone_receiver = $request -> phone_receiver ;
        $address_home -> address = $request -> address ;
        $address_home -> postal_code = $request -> postal_code ;
        $address_home -> client_id = $id_user ;
        $address_home -> save();

        return back()->with('success','آدرس با موفقیت ایجاد شد');
    }




    public function updateAddressHome(Request $request , $id){
        $request->validate([
            'title' => 'required|string',
            'name_receiver' => 'required|string',
            'phone_receiver' => 'required|numeric',
            'postal_code' => 'required|numeric',
            'address' => 'nullable|string',
        ]);
        $id_user = \Auth::user() -> id;
        $address_home = address_home::find($id);
        if($address_home -> client_id != $id_user){
            return back()->with('success','درخواست قابل اجرا نمی باشد');
        }
        $address_home -> title = $request -> title ;
        $address_home -> name_receiver = $request -> name_receiver ;
        $address_home -> phone_receiver = $request -> phone_receiver ;
        $address_home -> address = $request -> address ;
        $address_home -> postal_code = $request -> postal_code ;
        $address_home -> client_id = $id_user ;
        $address_home -> save();
        return back()->with('success','آدرس با موفقیت ویرایش شد');
    }
}
