<?php

namespace App\Http\Controllers\client;

use App\Models\panel\carts;
use App\Models\panel\factor;
use Illuminate\Http\Request;
use App\Models\panel\address_home;
use App\Http\Controllers\Controller;

class cartsController extends Controller
{

    public function allCart(){
        $id_user = \Auth::user() -> id;
        $allCarts = carts::orderBy('created_at','desc')->where('client_id',$id_user)->get();
        $AddressHome = address_home::orderBy('created_at','desc')->where('client_id',$id_user)->get();
        return view('client.product.allCarts',compact('allCarts','AddressHome'));
    }


    public function allBuyProduct(){
        $id_user = \Auth::user() -> id;
        $allOrder = factor::orderBy('created_at','desc')->where('client_id',$id_user)->where('name_factor',"factorProduct")->paginate(10);
        return view('client.product.allBuyProduct',compact('allOrder'));
    }


    public function createFactorCart(Request $request){
        $id_user = \Auth::user() -> id;
        $phone = \Auth::user() -> phone;
        $name = \Auth::user() -> name;
        $request->validate([
            'address' => 'required|numeric',
        ]);


        $find_address = address_home::find($request -> address);
        $allCarts = carts::orderBy('created_at','desc')->where('client_id',$id_user)->get();
        if($allCarts -> toArray() != []){
            foreach($allCarts as $item_allCarts){
                $array_allCarts[] = array(
                    "id" => $item_allCarts -> array_product -> id,
                    "name" => $item_allCarts -> array_product -> name,
                    "price" => $item_allCarts -> array_product -> price,
                    "image" => $item_allCarts -> array_product -> image,
                    "quantity" => $item_allCarts -> quantity,
                );

                $totalPrice[] = $item_allCarts->array_product->price * $item_allCarts->quantity;
            }
            $array_factor = array(
                "AllCarts" => $array_allCarts,
                "StatusSend" => 2, // وضعیت سفارش
                "TrackingCode" => "-", // کد رهگیری
                "AddressId" => $find_address -> id, // آیدی آدرس
                "Address" => $find_address, // کل آدرس
            );
            $new_price = array_sum($totalPrice);
            $new_factor = new factor();
            $new_factor -> name_factor = "factorProduct";
            $new_factor -> client_id = $id_user;
            $new_factor -> items_factor = $array_factor;
            $new_factor -> price = $new_price;
            $new_factor -> payment = 0;
            $new_factor -> phone = $phone;
            $new_factor -> name = $name;

            $new_factor -> type_name = "client";
            $new_factor ->save();

            carts::where('client_id', $id_user)->delete();
            
            return redirect('client/factor'.'/'.$new_factor -> id)->with('success',' فاکتور سفارش شما '.' با موفقیت ایجاد شد . بعد از پرداخت فاکتور به سفارش شما رسیدگی میشود ');

        }else{
            return back()->with('error','سبد خرید شما خالی می باشد');
        }
    }











    public function addCart(Request $request)
    {
        $id_user = \Auth::user() -> id;
        $carts = new carts();
        $carts->client_id = $id_user;
        $carts->product_id = $request->product_id;
        $carts->quantity = 1;
        $carts->save();
        return response()->json(['status' => 'added']);
    }
    public function cartIncrease(Request $request)
    {
        $carts = carts::where('client_id', auth()->id())
            ->where('product_id', $request->product_id)
            ->first();

        $carts->increment('quantity');

        return response()->json(['quantity' => $carts->quantity]);
    }
    public function cartDecrease(Request $request)
    {
        $carts = carts::where('client_id', auth()->id())
            ->where('product_id', $request->product_id)
            ->first();

        if ($carts->quantity > 1) {
            $carts->decrement('quantity');
        } else {
            $carts->delete();
        }

        return response()->json(['status' => 'updated']);
    }
}
