<?php

namespace App\Http\Controllers\client;

use App\Models\panel\factor;
use Illuminate\Http\Request;
use App\Models\portal\portals;

use Cookie;
use App\Models\User;
use App\Http\Controllers\Controller;

class factorController extends Controller
{
    public function panelFactor($id){
        $id_user = \Auth::user() -> id;
        $factor = factor::find($id);
        $all_portals = portals::where('active',1)->get();
        if($factor -> client_id == $id_user){
            return view('client.factor.factor',compact('factor','all_portals'));
        }else{
            redirect()->to('404')->send();
        }

    }
    

    public function allFactorNotPay(){
        $id_user = \Auth::user() -> id;
        $factor = factor::orderBy('created_at','desc')->where('client_id',$id_user)->where('payment',0)->paginate(10);
        return view('client.factor.allFactorNotPay',compact('factor'));
    }
    public function allFactorPayed(){
        $id_user = \Auth::user() -> id;
        $factor = factor::orderBy('created_at','desc')->where('client_id',$id_user)->paginate(10);
        return view('client.factor.allFactorNotPay',compact('factor'));
    }




    public function paymentFactorPortal(Request $request ,$id){
        $request->validate([
            'banks' => 'required|numeric',
        ]);
        $id_user = \Auth::user() -> id;
        $factor = factor::find($id);
        $factor -> banks =  $request -> banks;
        $factor -> save();
        return redirect('payFactor'.'/'.$factor -> id);  
    }





    public function goToCheck(Request $request , $id){
        $factor = factor::find($id);
        if(!$factor == null){
            if(($factor -> payment != 1) && ($factor -> payment != 2)){
                $name_user = $factor -> name;
                $new_priceproduct = $factor -> price;
                $phone = $factor -> phone;
                $banks = $factor -> banks;

                $cart_data = array(
                    'price'=> $new_priceproduct,
                    'name_user'=> $name_user,
                    'email'=> $phone,
                    'phone'=> $phone,
                    'factor'=> $id,
                );
                Cookie::forget('pays_factor');

                $item_data = json_encode($cart_data);
                $minutes = 25;
                Cookie::queue(Cookie::make('pays_factor', $item_data, $minutes));



               // $request->session()->put('id_payfactor', $id);

                $portals = portals::find($banks);
                if(($portals != null)){
                    $json_data = json_decode($portals -> data);
                    $code = $json_data -> code;

                    if(($portals -> active == 1) && ($portals -> portal == "zarinpal")){
                        return redirect('zarinpal')->with(compact('new_priceproduct','phone'));
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "payir")){
                        return redirect('payir')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "nextpay")){
                        return redirect('nextpay')->with(compact('new_priceproduct','phone')); 
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "idpay")){
                        return redirect('idpay')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "poolam")){
                        return redirect('poolam')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "payping")){
                        return redirect('payping')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "zibal")){
                        return redirect('zibal')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "vandar")){
                        return redirect('vandar')->with(compact('new_priceproduct','phone'));  
                    }
                    elseif(($portals -> active == 1) && ($portals -> portal == "plisio")){
                        return redirect('plisio')->with(compact('new_priceproduct','phone'));  
                    }
                    else{
                        return back()->with('error','درگاه مورد نظر فعال نمی باشد');
                    }

                }else{
                    return back()->with('error','درگاه را انتخاب کنيد');
                }   
            }elseif($factor -> payment == 1){
                return back()->with('error','فاکتور قبلا پرداخت شده است');
            }elseif($factor -> payment == 2){
                return back()->with('error','فاکتور لغو شده است');
            }else{
                redirect()->to('404')->send();
            }
        }else{
            redirect()->to('404')->send();
        }
    }














}
