<?php

namespace App\Http\Controllers\client;

use App\Models\User;
use Kavenegar\KavenegarApi;
use Illuminate\Http\Request;
use App\Models\panel\sms\sendSms;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use App\Models\panel\sms\configurationSms;
use App\Models\panel\sms\smsir\smsIr_sendMessage;

class profileController extends Controller
{
    public function profile($id){
        $id_user = \Auth::user() -> id;
        if($id_user == $id){
            $editUser = User::find($id_user);
            return view('client.editClient',compact('editUser'));
        }else{
            redirect()->to('404')->send();
        }
    }

    public function editProfile(Request $request , $id){
        \Auth::user() -> id;
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            'password' => 'nullable|string|min:6|confirmed',
            'avatar' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $id_user = \Auth::user() -> id;
        $User = User::find($id);

        $User -> name = $request -> name;
        if($id_user == $id){
            if($request -> email == $User -> email){
                $User -> email = $request -> email;
            }else{
                $findEmail = User::where('email', $request -> email) -> get() -> toArray();
                if($findEmail != []){
                    return back()->with('error','ایمیل وارد شده موجود میباشد لطفا یک ایمیل دیگر وارد کنید');
                }else{
                    $User -> email = $request -> email;
                }
            }
            if($request -> phone == $User -> phone){
                $User -> phone = $request -> phone;
            }else{
                $findPhone = User::where('phone', $request -> phone) -> get() -> toArray();
                if($findPhone != []){
                    return back()->with('error','شماره وارد شده موجود میباشد لطفا یک شماره دیگر وارد کنید');
                }else{
                    $User->active = 2;
                    $User -> phone = $request -> phone;
                }
            }
            if($request->password){
                $User -> password  = Hash::make($request->password);
                
            }
            $User -> save();

            if($request -> avatar){
                $avatar = $request -> avatar -> getClientOriginalName();
                $User -> avatar = $request -> avatar -> getClientOriginalName();
                $request -> file('avatar') -> move('upload', $avatar);
                $User -> save();
            }
            return back()->with('success','پروفایل با موفقیت ویرایش شد');
        }else{
            return back()->with('success','دستور قابل اجرا نمی باشد');
        }

    }



    public function checkCodeSend(Request $request){
        $id_user = \Auth::user() -> id;
        $name = \Auth::user() -> name;
        $phone = \Auth::user() -> phone;
        $user_code = \Auth::user() -> code_confirmation;

        if($request -> confirmation){
            $request->validate([
                'code' => 'required|string|max:255',
            ]);
            if($user_code == $request -> code){
                $find_user = User::find($id_user);
                $find_user->code_confirmation = null;
                $find_user->active = 1;
                $find_user->save();
                return back()->with('success','شماره موبایل شما با موفقیت فعال شد');
            }else{
                return back()->with('error','کد ارسال شده صحیح نمی باشد');
            }
        }else{

            $randomid = rand(100,10000); 

            $find_user = User::find($id_user);
            $find_user-> code_confirmation = $randomid;
            $find_user->save();

            $pm_sms = ' سلام ' . $name . ' عزیز '.PHP_EOL.
            'کد تایید شما : '.PHP_EOL.$randomid;
            
            $new_send_sms = new sendSms();
            $sending = $new_send_sms -> sendSms($pm_sms,$phone);
            if($sending["status"] == 1){
                return back()->with('success','پیامک با موفقیت ارسال شد');
            }else{
                return back()->with('error','متاسفانه پیامک با موفقیت ارسال نشد');
            }
        }
        
    }

}
