<?php

namespace App\Http\Controllers\client;

use Kavenegar\KavenegarApi;
use App\Models\panel\ticket;
use Illuminate\Http\Request;
use App\Models\panel\settings;
use App\Models\panel\pm_ticket;
use App\Models\panel\department;
use App\Models\panel\sms\sendSms;
use App\Http\Controllers\Controller;
use Hekmatinasser\Verta\Facades\Verta;
use App\Models\panel\sms\configurationSms;
use App\Models\panel\sms\smsir\smsIr_sendMessage;

class ticketController extends Controller
{
    public function addTicket(){
        $id_user = \Auth::user() -> id;
        $all_department = department::orderBy('created_at','desc')->get();
        return view('client.ticket.addTicket',compact('all_department'));
    }


    public function allTicket(){
        $id_user = \Auth::user() -> id;
        $allTicket = ticket::orderBy('created_at','desc')->where('client_id',$id_user)-> paginate(10);
        $all_department = department::orderBy('created_at','desc')->get();
        return view('client.ticket.allTicket',compact('allTicket','all_department'));
    }




    public function searchTicket(Request $request){
        $id_user = \Auth::user() -> id;
        $all_department = department::orderBy('created_at','desc')->get();
        $query = ticket::orderBy('created_at','desc')->where('client_id',$id_user);
        

        
        if($request->selectvalue == 'title'){
            $query -> where('title', 'LIKE', '%' . $request->search . '%');
        }
        if($request->selectvalue == 'id'){
            $query -> where('id',$request->search);
        }
        if($request->department){
            $query -> where('department',$request->department);
        }
        if($request->importance){
            $query -> where('importance',$request->importance);
        }
        if($request->status){
            $query -> where('status',$request->status);
        }
        

        if((!$request->department) && (!$request->importance) && (!$request->status) && ($request->selectvalue != 'title') && ($request->selectvalue != 'id')){
            $query -> where('title', 'LIKE', '%' . $request->search . '%');
        }


        $allTicket = $query->paginate(10);
        $allTicket->appends(request()->input())->links();

        return view('client.ticket.allTicket',compact('allTicket','all_department'));
    }




    public function create(Request $request){
        $id_user = \Auth::user() -> id;
        $name = \Auth::user() -> name;
        $phone_client = \Auth::user() -> phone;
        $active_sms = \Auth::user() -> active_sms;
        $request->validate([
            'title' => 'required|string',
            'importance' => 'required|numeric',
            'department' => 'required|numeric',
            'description' => 'required|string',
            "file" => "nullable|mimes:jpeg,png,jpg,pdf,zip|max:4096"
        ]);

        $ticket = new ticket();
        $ticket -> title = $request -> title;
        $ticket -> importance = $request -> importance;
        $ticket -> department = $request -> department;
        $ticket -> client_id = $id_user;
        $ticket -> status = 1 ;
        $ticket -> save();

        $pm_ticket = new pm_ticket();
        $pm_ticket -> description = $request -> description;
        $pm_ticket -> ticket_id = $ticket -> id;
        $pm_ticket -> client_id = $id_user;
        $pm_ticket -> type = 'client';
        $pm_ticket -> save();
        if($request->file){
            $file = $request -> file -> getClientOriginalName();
            $pm_ticket -> file = $request -> file -> getClientOriginalName();
            $request -> file('file') -> move('upload/ticket', $file);
            $pm_ticket -> save();
        }




    //ارسال پیامک شروع

        $settings = settings::find(1);
        if($settings != null){
            $attributes = json_decode($settings->activation,true);
            if($attributes == true){
                $send_sms_ticket_client = $attributes[0]['send_sms_ticket_client'];
                $send_sms_ticket_admin = $attributes[0]['send_sms_ticket_admin'];
                
                if(($send_sms_ticket_client == 1) && ($active_sms == 1)){// ارسال به نماینده
                    $text = 'تیکت شما با موفقیت ارسال شد . همکاران ما به زودی به شما پاسخ خواهند داد';
                    $pm_sms = ' سلام ' . $name . ' عزیز '.PHP_EOL.
                    $text.PHP_EOL.
                    'نام سایت : '.$settings -> site_name;
                    $phone = $phone_client;

                    $new_send_sms = new sendSms();
                    $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                }

                if($send_sms_ticket_admin == 1){// ارسال به ادمین
                    $text = 'تیکت جدیدی ارسال شده . لطفا در اسرع وقت پاسخ دهید';
                    $pm_sms = 'سلام ادمین گرامی'.PHP_EOL.
                    $text.PHP_EOL.
                    'موضوع تیکت : '.$request -> title;
                    $phone = $settings -> phone_admin;

                    $new_send_sms = new sendSms();
                    $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                }
                    
                
            }
        }
        
    //ارسال پیامک پایان


        return redirect('client/ticket'.'/'.$ticket -> id)->with('success','تیکت با موفقیت ایجاد شد');
    }


    public function ticket($id){
        $id_user = \Auth::user() -> id;
        $ticket = ticket::findOrFail($id);
        if($ticket -> client_id == $id_user){
            $all_pm_ticket = pm_ticket::orderBy('created_at','desc') -> where('ticket_id',$id)->where('client_id',$ticket -> client_id)->paginate(10);
            return view('client.ticket.ticket',compact('ticket','all_pm_ticket'));
        }else{
            redirect()->to('404')->send();
        }
    }


    public function updateTicket(Request $request , $id){
        $id_user = \Auth::user() -> id;
        $name = \Auth::user() -> name;
        $phone_client = \Auth::user() -> phone;
        $active_sms = \Auth::user() -> active_sms;

        if($request -> close){
            $ticket = ticket::find($id);
            $ticket -> status = 2 ;
            $ticket -> save();            
            return back()->with('success','تیک با موفقیت بسته شد');
        }else{
            $request->validate([
                'description' => 'required|string',
                "file" => "nullable|mimes:jpeg,png,jpg,pdf,zip|max:4096"
            ]);
            $ticket = ticket::find($id);
            $ticket -> status = 3 ;
            $ticket -> save();
    
            $pm_ticket = new pm_ticket();
            $pm_ticket -> description = $request -> description;
            $pm_ticket -> ticket_id = $ticket -> id;
            $pm_ticket -> client_id = $id_user;
            $pm_ticket -> type = 'client';
            $pm_ticket -> save();
            if($request->file){
                $file = $request -> file -> getClientOriginalName();
                $pm_ticket -> file = $request -> file -> getClientOriginalName();
                $request -> file('file') -> move('upload/ticket', $file);
                $pm_ticket -> save();
            }






            //ارسال پیامک شروع

            $settings = settings::find(1);
            if($settings != null){
                $attributes = json_decode($settings->activation,true);
                if($attributes == true){
                    $send_sms_ticket_client = $attributes[0]['send_sms_ticket_client'];
                    $send_sms_ticket_admin = $attributes[0]['send_sms_ticket_admin'];

                    if(($send_sms_ticket_client == 1) && ($active_sms == 1)){// ارسال به نماینده
                        $text = 'تیکت شما با موفقیت ارسال شد . همکاران ما به زودی به شما پاسخ خواهند داد';
                        $pm_sms = ' سلام ' . $name . ' عزیز '.PHP_EOL.
                        $text.PHP_EOL.
                        'نام سایت : '.$settings -> site_name;

                        $phone = $phone_client;

                        $new_send_sms = new sendSms();
                        $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                    }

                    if($send_sms_ticket_admin == 1){// ارسال به ادمین
                        $text = 'تیکت جدیدی ارسال شده . لطفا در اسرع وقت پاسخ دهید';
                        $pm_sms = 'سلام ادمین گرامی'.PHP_EOL.
                        $text.PHP_EOL.
                        'موضوع تیکت : '.$ticket -> title;
                        $phone = $settings -> phone_admin;
                        
                        $new_send_sms = new sendSms();
                        $sending = $new_send_sms -> sendSms($pm_sms,$phone);
                    }
                        
                    
                }
            }
            
        //ارسال پیامک پایان

            return back()->with('success','تیک با موفقیت ارسال شد');
        }



    }

}
