<?php

namespace App\Http\Controllers\panel;

use App\Models\User;
use App\Models\panel\address_home;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class addressHomeController extends Controller
{
    
    public function addAddressHome(){
        $client = User::orderBy('created_at','desc')->where('account_type',2)->get();
        return view('panel.addresshome.addAddressHome',compact('client'));
    }

    public function editAddressHome($id){
        $client = User::orderBy('created_at','desc')->where('account_type',2)->get();
        $AddressHome = address_home::find($id);
        return view('panel.addresshome.editAddressHome',compact('AddressHome','client'));
    }
    
    public function allAddressHome(){
        $AddressHome = address_home::orderBy('created_at','desc')->paginate(10);
        return view('panel.addresshome.allAddressHome',compact('AddressHome'));
    }


    public function create(Request $request){

        $request->validate([
            'title' => 'required|string',
            'name_receiver' => 'required|string',
            'phone_receiver' => 'required|numeric',
            'postal_code' => 'required|numeric',
            'client' => 'required|numeric',
            'address' => 'nullable|string',
        ]);

        $address_home = new address_home();
        $address_home -> title = $request -> title ;
        $address_home -> name_receiver = $request -> name_receiver ;
        $address_home -> phone_receiver = $request -> phone_receiver ;
        $address_home -> address = $request -> address ;
        $address_home -> postal_code = $request -> postal_code ;
        $address_home -> client_id = $request -> client ;
        $address_home -> save();

        return back()->with('success','آدرس با موفقیت ایجاد شد');
    }




    public function updateAddressHome(Request $request , $id){

        $request->validate([
            'title' => 'required|string',
            'name_receiver' => 'required|string',
            'phone_receiver' => 'required|numeric',
            'postal_code' => 'required|numeric',
            'client' => 'required|numeric',
            'address' => 'nullable|string',
        ]);

        $address_home = address_home::find($id);
        $address_home -> title = $request -> title ;
        $address_home -> name_receiver = $request -> name_receiver ;
        $address_home -> phone_receiver = $request -> phone_receiver ;
        $address_home -> address = $request -> address ;
        $address_home -> postal_code = $request -> postal_code ;
        $address_home -> client_id = $request -> client ;
        $address_home -> save();
        return back()->with('success','آدرس با موفقیت ویرایش شد');
    }

    public function deleteAddressHome($id){
        address_home::find($id) -> delete();
        return back()->with('success','آدرس با موفقیت حذف شد');
    }
}
