<?php

namespace App\Http\Controllers\panel;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\User;
use Hash;
class adminController extends Controller
{
    public function addAdmin(){
        return view('panel.admin.addAdmin');
    }

    public function allAdmin(){
        $all_user = User::where('account_type',1) ->paginate(10);
        return view('panel.admin.allAdmin',compact('all_user'));
    }

    public function editAdmin($id){
        $editUser = User::find($id);
        return view('panel.admin.editAdmin',compact('editUser'));
    }

    public function create(Request $request){
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric|unique:users',
            'password' => 'required|string|min:6|confirmed',
            'avatar' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);
 
        $User = new User();
        $User -> name = $request -> name;
        $User -> email = $request -> email;
        $User -> password  = Hash::make($request->password);
        $User -> account_type = 1;
        $User -> save();
        if($request -> avatar){
            $avatar = $request -> avatar -> getClientOriginalName();
            $User -> avatar = $request -> avatar -> getClientOriginalName();
            $request -> file('avatar') -> move('upload', $avatar);
            $User -> save();
        }
         return back()->with('success','ادمین با موفقیت ایجاد شد');
    }

    public function updateAdmin(Request $request , $id){
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            'password' => 'nullable|string|min:6|confirmed',
            'avatar' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $User = User::find($id);
        $User -> name = $request -> name;
        if($request -> email == $User -> email){
            $User -> email = $request -> email;
        }else{
            $findEmail = User::where('email', $request -> email) -> get() -> toArray();
            if($findEmail != []){
                return back()->with('error','ایمیل وارد شده موجود میباشد لطفا یک ایمیل دیگر وارد کنید');
            }else{
                $User -> email = $request -> email;
            }
        }

        if($request -> phone == $User -> phone){
            $User -> phone = $request -> phone;
        }else{
            $findPhone = User::where('phone', $request -> phone) -> get() -> toArray();
            if($findPhone != []){
                return back()->with('error','شماره وارد شده موجود میباشد لطفا یک شماره دیگر وارد کنید');
            }else{
                $User -> phone = $request -> phone;
            }
        }
        if($request->password){
            $User -> password  = Hash::make($request->password);
        }
        $User -> account_type = 1;
        $User -> save();
        if($request->avatar){
            $avatar = $request -> avatar -> getClientOriginalName();
            $User -> avatar = $request -> avatar -> getClientOriginalName();
            $request -> file('avatar') -> move('upload', $avatar);
            $User -> save();
        }
        return back()->with('success','ادمین با موفقیت ویرایش شد');
    }

    public function deleteAdmin($id){
        $user = \Auth::user() -> id;
        if($user == $id){
            return back()->with('error','شما نمی توانید اکانت خود را حذف کنید');
        }else{
            User::find($id) -> delete();
        }
        return back()->with('success','ادمین با موفقیت حذف شد');
    }
}
