<?php

namespace App\Http\Controllers\panel\campaign;


use Illuminate\Http\Request;

use App\Models\panel\campaign;
use App\Http\Controllers\Controller;
use App\Models\panel\category_campaign;

class campaignController extends Controller
{
    public function addCampaign(){
        $categoryCampaign = category_campaign::orderBy('created_at','desc')->get();
        return view('panel.campaign.campaign.addCampaign',compact('categoryCampaign'));
    }

    
    public function editCampaign($id){
        $categoryCampaign = category_campaign::orderBy('created_at','desc')->get();
        $Campaign = campaign::find($id);
        return view('panel.campaign.campaign.editCampaign',compact('Campaign','categoryCampaign'));
    }


    public function profileCampaign($id){
        $campaign = campaign::find($id);
        return view('panel.campaign.campaign.profileCampaign',compact('campaign'));
    }




    public function allCampaign(){
        $Campaign = campaign::orderBy('created_at','desc')->paginate(10);
        return view('panel.campaign.campaign.allCampaign',compact('Campaign'));
    }


    public function create(Request $request){
        $request->validate([
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'status' => 'required|numeric',
            'categoryCampaign' => 'required|numeric',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $Campaign = new campaign();
        $Campaign -> name = $request -> name ;
        $Campaign -> description = $request -> description ;
        $Campaign -> price = $request -> price ;
        $Campaign -> id_category = $request -> categoryCampaign ;
        $Campaign -> status = $request -> status ;
        $Campaign -> save();

        $image = $request -> image -> getClientOriginalName();
        $Campaign -> image = $request -> image -> getClientOriginalName();
        $request -> file('image') -> move('upload/Campaign', $image);
        $Campaign -> save();



        return back()->with('success','کمپین با موفقیت ایجاد شد');
    }



    public function updateCampaign(Request $request , $id){
        $request->validate([
            'name' => 'required|string',
            'description' => 'required|string',
            'price' => 'required|numeric',
            'status' => 'required|numeric',
            'categoryCampaign' => 'required|numeric',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);

        $Campaign = campaign::find($id);
        $Campaign -> name = $request -> name ;
        $Campaign -> description = $request -> description ;
        $Campaign -> price = $request -> price ;
        $Campaign -> id_category = $request -> categoryCampaign ;
        $Campaign -> status = $request -> status ;
        $Campaign -> save();

        if($request -> image){
            $image = $request -> image -> getClientOriginalName();
            $Campaign -> image = $request -> image -> getClientOriginalName();
            $request -> file('image') -> move('upload/Campaign', $image);
            $Campaign -> save();
        }
        return back()->with('success','کمپین با موفقیت ویرایش شد');
    }

    public function deleteCampaign($id){
        campaign::find($id) -> delete();
        return back()->with('success','کمپین با موفقیت حذف شد');
    }





}
