<?php

namespace App\Http\Controllers\panel\campaign;


use App\Models\panel\category_campaign;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class categoryCampaignController extends Controller
{
    public function addCategoryCampaign(){
        return view('panel.campaign.categorycampaign.addCategoryCampaign');
    }

    
    public function editCategoryCampaign($id){
         $CategoryCampaign = category_campaign::find($id);
         return view('panel.campaign.categorycampaign.editCategoryCampaign',compact('CategoryCampaign'));
    }


    public function allCategoryCampaign(){
        $CategoryCampaign = category_campaign::orderBy('created_at','desc')->paginate(10);
        return view('panel.campaign.categorycampaign.allCategoryCampaign',compact('CategoryCampaign'));
    }


    public function create(Request $request){
        $request->validate([
            'name' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $CategoryCampaign = new category_campaign();
        $CategoryCampaign -> name = $request -> name ;
        if($request -> active){
            $CategoryCampaign -> active = 1;
        }else{
            $CategoryCampaign -> active = 0;
        }
        $CategoryCampaign -> save();

        $image = $request -> image -> getClientOriginalName();
        $CategoryCampaign -> image = $request -> image -> getClientOriginalName();
        $request -> file('image') -> move('upload/CategoryCampaign', $image);
        $CategoryCampaign -> save();



        return back()->with('success','دسته بندی کمپین با موفقیت ایجاد شد');
    }



    public function updateCategoryCampaign(Request $request , $id){
        $request->validate([
            'name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);

        $CategoryCampaign = category_campaign::find($id);
        $CategoryCampaign -> name = $request -> name ;
        if($request -> active){
            $CategoryCampaign -> active = 1;
        }else{
            $CategoryCampaign -> active = 0;
        }
        $CategoryCampaign -> save();

        if($request -> image){
            $image = $request -> image -> getClientOriginalName();
            $CategoryCampaign -> image = $request -> image -> getClientOriginalName();
            $request -> file('image') -> move('upload/CategoryCampaign', $image);
            $CategoryCampaign -> save();
        }
        return back()->with('success','دسته بندی کمپین با موفقیت ویرایش شد');
    }

    public function deleteCategoryCampaign($id){
        category_campaign::find($id) -> delete();
        return back()->with('success','دسته بندی کمپین با موفقیت حذف شد');
    }
}
