<?php

namespace App\Http\Controllers\panel;

use Carbon\Carbon;
use App\Models\User;
use App\Models\panel\order;
use App\Models\panel\factor;
use App\Models\panel\ticket;
use Illuminate\Http\Request;
use Hekmatinasser\Verta\Verta;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;






class clientController extends Controller
{
    public function addClient(){
        return view('panel.client.addClient');
    }

    public function allClient(){
        $all_user = User::orderBy('created_at','desc') -> where('account_type',2)->where('active','!=',0) ->paginate(10);
        return view('panel.client.allClient',compact('all_user'));
    }




    public function allBlockClient(){
        $all_user = User::orderBy('created_at','desc') -> where('active',0) -> where('account_type',2) ->paginate(10);
        return view('panel.client.allBlockClient',compact('all_user'));
    }

    
    public function editClient($id){
        $editUser = User::find($id);
        return view('panel.client.editClient',compact('editUser'));
    }





    public function create(Request $request){
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric|unique:users',
            'avatar' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);

        $User = new User();
        $User -> name = $request -> name;
        $User -> email = $request -> email;
        $User -> phone = $request -> phone;


        if($request -> active_sms){
            $User -> active_sms = 1;
        }else{
            $User -> active_sms = 0;
        }
        
        $User -> password  = Hash::make($request->password);
        $User -> account_type = 2;
        $User -> save();

        $avatar = $request -> avatar -> getClientOriginalName();
        $User -> avatar = $request -> avatar -> getClientOriginalName();
        $request -> file('avatar') -> move('upload', $avatar);
        $User -> save();




        return back()->with('success','کاربر با موفقیت ایجاد شد');
    }

    public function updateClient(Request $request , $id){


        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255',
            'password' => 'nullable|string|min:6|confirmed',
            'phone' => 'required|regex:/(09)[0-9]{9}/|digits:11|numeric',
            'avatar' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $User = User::find($id);

        $User -> name = $request -> name;
        if($request -> email == $User -> email){
            $User -> email = $request -> email;
        }else{
            $findEmail = User::where('email', $request -> email) -> get() -> toArray();
            if($findEmail != []){
                return back()->with('error','ایمیل وارد شده موجود میباشد لطفا یک ایمیل دیگر وارد کنید');
            }else{
                $User -> email = $request -> email;
            }
        }
        if($request -> phone == $User -> phone){
            $User -> phone = $request -> phone;
        }else{
            $findPhone = User::where('phone', $request -> phone) -> get() -> toArray();
            if($findPhone != []){
                return back()->with('error','شماره وارد شده موجود میباشد لطفا یک شماره دیگر وارد کنید');
            }else{
                $User -> phone = $request -> phone;
            }
        }
        if($request->password){
            $User -> password  = Hash::make($request->password);
        }
        if($request -> active_sms){
            $User -> active_sms = 1;
        }else{
            $User -> active_sms = 0;
        }
        $User -> save();


        if($request -> avatar){
            $avatar = $request -> avatar -> getClientOriginalName();
            $User -> avatar = $request -> avatar -> getClientOriginalName();
            $request -> file('avatar') -> move('upload', $avatar);
            $User -> save();
        }






        return back()->with('success','کاربر با موفقیت ویرایش شد');
    }

    public function deleteClient($id){
        $user = \Auth::user() -> id;
        if($user == $id){
            return back()->with('error','شما نمی توانید اکانت خود را حذف کنید');
        }else{
            User::find($id) -> delete();
        }
        return back()->with('success','کاربر با موفقیت حذف شد');
    }

    public function searchClient(Request $request){
        $master = $request->master;
        if($request->selectvalue == 'name'){
            $all_user = User::orderBy('created_at','desc')-> where('account_type',2)->where('active','!=',0) -> where('name', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        elseif($request->selectvalue == 'email'){
            $all_user = User::orderBy('created_at','desc')-> where('account_type',2)->where('active','!=',0) -> where('email', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        else{
            $all_user = User::orderBy('created_at','desc')-> where('account_type',2)->where('active','!=',0) -> where('phone', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        return view('panel.client.allClient',compact('all_user'));
    }

    public function searchBlockClient(Request $request){
        if($request->selectvalue == 'name'){
            $all_user = User::orderBy('created_at','desc') -> where('active',0)-> where('account_type',2) -> where('name', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        elseif($request->selectvalue == 'email'){
            $all_user = User::orderBy('created_at','desc') -> where('active',0)-> where('account_type',2) -> where('email', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        else{
            $all_user = User::orderBy('created_at','desc') -> where('active',0)-> where('account_type',2) -> where('phone', 'LIKE', '%' . $request->search . '%')
            ->paginate(10);
            $all_user->appends(request()->input())->links();
        }
        return view('panel.client.allBlockClient',compact('all_user'));
    }

    public function profileClient($id){
        $find_user = User::find($id);
        $id_user = $id;

        $allTicket = ticket::orderBy('created_at','desc')->where('client_id',$id_user)->count();

        $allFactor = factor::orderBy('created_at','desc')->where('client_id',$id_user)->get();
        $factorCampaign = $allFactor -> where('name_factor','factorCampaign');
        $factorSubsidy = $allFactor -> where('name_factor','factorSubsidy');
        $factorProduct = $allFactor -> where('name_factor','factorProduct');

        $all_factorCampaign = factor::orderBy('created_at','desc')-> where('name_factor','factorCampaign') -> where('client_id',$id_user)
        ->paginate(10,['*'],'factorCampaign');
        $all_factorSubsidy = factor::orderBy('created_at','desc')-> where('name_factor','factorSubsidy') -> where('client_id',$id_user)
        ->paginate(10,['*'],'factorSubsidy');
        $all_factorProduct = factor::orderBy('created_at','desc')-> where('name_factor','factorProduct') -> where('client_id',$id_user)
        ->paginate(10,['*'],'factorProduct');


        return view('panel.client.profileClient',compact('find_user','factorCampaign','factorSubsidy',
        'factorProduct','all_factorCampaign','all_factorSubsidy','all_factorProduct','allTicket'));



        
    }

    public function accessClient(){
        $all_user = User::where('account_type',2)->get();
        return view('panel.client.accessClient',compact('all_user'));
    }

    public function updateAccessClient(Request $request){

       $id_Client = $request -> id_client;
       $active_sms = $request -> active_sms;


        foreach($id_Client as $key => $n ){
            $Client = User::find($id_Client[$key]);
            

            if($active_sms[$key] == 1){
                $Client -> active_sms = 1;
            }else{
                $Client -> active_sms = 0;
            }
            
            $Client -> save();
        }
       return back()->with('success','دسترسی کاربر ها با موفقیت ویرایش شد');
    }


    public function disableClient($id){
        User::where('id', $id)->update(['active' => 0]);
        return back()->with('success',"کاربر با موفقیت غیر فعال شد");
    }
    public function activeClient($id){
        User::where('id', $id)->update(['active' => 1]);
        return back()->with('success',"کاربر با موفقیت فعال شد");
    }




}
