<?php

namespace App\Http\Controllers\panel;

use Cookie;
use Carbon\Carbon;
use App\Models\User;
use App\Models\panel\client;
use App\Models\panel\factor;
use Illuminate\Http\Request;
use App\Models\panel\ticket;
use App\Models\panel\settings;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Hekmatinasser\Verta\Facades\Verta;

class indexController extends Controller
{
    
    public function index(){
        if(!\Auth::check()){
            return redirect('/login');
        }elseif(\Auth::user() -> account_type == 2){
            redirect()->to('client/index')->send();
        }elseif(\Auth::user() -> account_type != 1){
            redirect()->to('404')->send();
        }
        

		$now = Carbon::now();

        $allTicket = ticket::orderBy('created_at','desc')->count();

        $allFactor = factor::orderBy('created_at','desc')->get();
        $factorCampaign = $allFactor -> where('name_factor','factorCampaign');
        $factorSubsidy = $allFactor -> where('name_factor','factorSubsidy');
        $factorProduct = $allFactor -> where('name_factor','factorProduct');


        // Build an array of the dates we want to show, oldest first
        $dates = collect();
        foreach( range( -6, 0 ) AS $i ) {
            
            $date = Carbon::now()->addDays( $i )->format( 'Y-m-d' );
            $dates->put( $date, 0);
        }

        // Get the post counts
        $posts = factor::where( 'created_at', '>=', $dates->keys()->first() )
                    ->where(function($q) {
                        $q->where('name_factor', 'factorCampaign')
                        ->orWhere('name_factor', 'factorSubsidy');
                    })
                    
                    ->groupBy( 'date' )
                    ->orderBy( 'date' )
                    ->get( [
                        DB::raw( 'DATE( created_at ) as date' ),
                        DB::raw( 'COUNT( * ) as "count"' )
                    ] )
                    ->pluck( 'count', 'date' );
        // Merge the two collections; any results in `$posts` will overwrite the zero-value in `$dates`

       // @foreach ( $dates as $date => $count ) 
        // <p> {{ $date }} = {{ $count }}</p>
        // @endforeach
        $new_deta_cahrt_1 = $dates->merge( $posts );





        return view('index',compact('allTicket','factorCampaign','factorSubsidy','factorProduct','new_deta_cahrt_1'));
    }



    public function setCookieTheme(Request $request){
        $theme = Cookie::get('cookie_theme');
        if($theme == 'dark-only'){
            $th = 'light-only';
            $minutes = 43200;
            Cookie::queue(Cookie::make('cookie_theme', $th, $minutes));

            return response()->json([
                "theme" => $th,
    
            ]);
        }else{
            $th = 'dark-only';
            $minutes = 43200;
            Cookie::queue(Cookie::make('cookie_theme', $th, $minutes));
            return response()->json([
                "theme" => $th,
            ]);
        }
    }
}
