<?php

namespace App\Http\Controllers\panel;

use App\Models\panel\news;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class newsController extends Controller
{
    public function addNews(){
        return view('panel.news.addNews');
    }

    public function allNews(){
        $all_user = news::paginate(10);
        return view('panel.news.allNews',compact('all_user'));
    }

    public function editNews($id){
        $editUser = news::find($id);
        return view('panel.news.editNews',compact('editUser'));
    }

    public function create(Request $request){
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
        ]);
        $User = new news();
        $User -> title = $request -> title;
        $User -> description = $request -> description;
        if($request -> indexs){
            $User -> indexs = 1;
         }else{
            $User -> indexs = 0;
         }
        $User -> save();
        return back()->with('success','اخبار با موفقیت ایجاد شد');
    }

    public function updateNews(Request $request , $id){
        $request->validate([
            'title' => 'required|string|max:255',
            'description' => 'required|string',
         ]);
        $User = news::find($id);
        $User -> title = $request -> title;
        $User -> description = $request -> description;
        if($request -> indexs){
            $User -> indexs = 1;
         }else{
            $User -> indexs = 0;
         }

        $User -> save();
        return back()->with('success','اخبار با موفقیت ویرایش شد');
    }

    public function deleteNews($id){
       news::find($id) -> delete();
        return back()->with('success','اخبار با موفقیت حذف شد');
    }
}
