<?php

namespace App\Http\Controllers\panel\product;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\panel\category_product;
class categoryProductController extends Controller
{
    
    public function addCategoryProduct(){
        return view('panel.product.categoryproduct.addCategoryProduct');
    }

    
    public function editCategoryProduct($id){
         $CategoryProduct = category_product::find($id);
         return view('panel.product.categoryproduct.editCategoryProduct',compact('CategoryProduct'));
    }


    public function allCategoryProduct(){
        $CategoryProduct = category_product::orderBy('created_at','desc')->paginate(10);
        return view('panel.product.categoryproduct.allCategoryProduct',compact('CategoryProduct'));
    }


    public function create(Request $request){
        $request->validate([
            'name' => 'required|string',
            'image' => 'required|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $CategoryProduct = new category_product();
        $CategoryProduct -> name = $request -> name ;
        if($request -> active){
            $CategoryProduct -> active = 1;
        }else{
            $CategoryProduct -> active = 0;
        }
        $CategoryProduct -> save();

        $image = $request -> image -> getClientOriginalName();
        $CategoryProduct -> image = $request -> image -> getClientOriginalName();
        $request -> file('image') -> move('upload/categoryProduct', $image);
        $CategoryProduct -> save();



        return back()->with('success','دسته بندی محصول با موفقیت ایجاد شد');
    }



    public function updateCategoryProduct(Request $request , $id){
        $request->validate([
            'name' => 'required|string',
            'image' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);

        $CategoryProduct = category_product::find($id);
        $CategoryProduct -> name = $request -> name ;
        if($request -> active){
            $CategoryProduct -> active = 1;
        }else{
            $CategoryProduct -> active = 0;
        }
        $CategoryProduct -> save();

        if($request -> image){
            $image = $request -> image -> getClientOriginalName();
            $CategoryProduct -> image = $request -> image -> getClientOriginalName();
            $request -> file('image') -> move('upload/categoryProduct', $image);
            $CategoryProduct -> save();
        }
        return back()->with('success','دسته بندی محصول با موفقیت ویرایش شد');
    }

    public function deleteCategoryProduct($id){
        category_product::find($id) -> delete();
        return back()->with('success','دسته بندی محصول با موفقیت حذف شد');
    }
}
