<?php

namespace App\Http\Controllers\panel;

use App\Models\User;
use App\Models\panel\client;
use App\Models\panel\factor;
use Illuminate\Http\Request;
use App\Models\panel\settings;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Facades\Excel;

class settingsController extends Controller
{
    public function index(){
        $settings = settings::find(1);
        return view('settings') ->with(compact('settings'));
    }
    public function settings(Request $request){
        $request->validate([
            'site_name' => 'nullable|string|max:255',
            'text_profile' => 'nullable|string|max:255',
            'logo' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
            'logo_icon' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
            'logo_login' => 'nullable|image|mimes:jpeg,png,jpg|max:4096',
        ]);
        $settings = settings::all()->ToArray();
        if($settings == []){
            $settings = new settings;
            $settings -> site_name = $request -> site_name;
            $settings -> text_profile = $request -> text_profile;

            if($request -> send_sms_ticket_admin){
                $send_sms_ticket_admin = 1;
            }else{
                $send_sms_ticket_admin = 0;
            }
            if($request -> send_sms_ticket_client){
                $send_sms_ticket_client = 1;
            }else{
                $send_sms_ticket_client = 0;
            }
            
            if($request -> send_sms_ticket_reseller){
                $send_sms_ticket_reseller = 1;
            }else{
                $send_sms_ticket_reseller = 0;
            }
            if($request -> send_sms_register){
                $send_sms_register = 1;
            }else{
                $send_sms_register = 0;
            }
            if($request -> send_sms_login){
                $send_sms_login = 1;
            }else{
                $send_sms_login = 0;
            }
            



            if($request -> sms_order){
                $sms_order = 1;
            }else{
                $sms_order = 0;
            }
            if($request -> sms_goods){
                $sms_goods = 1;
            }else{
                $sms_goods = 0;
            }





            $activation_array = array([
                'send_sms_ticket_client' => $send_sms_ticket_client,
                'send_sms_ticket_admin' => $send_sms_ticket_admin,
                'send_sms_ticket_reseller' => $send_sms_ticket_reseller,
                'send_sms_register' => $send_sms_register,
                'send_sms_login' => $send_sms_login,

                'sms_order' => $sms_order,
                'sms_goods' => $sms_goods,

                
            ]);

            $settings -> activation = json_encode($activation_array);

            $settings -> save();
            if($request -> logo){
                $logo = $request -> logo -> getClientOriginalName();
                $settings -> logo = $request -> logo -> getClientOriginalName();
                $request -> file('logo') -> move('upload', $logo);
                $settings -> save();
            }
            if($request -> logo_icon){
                $logo_icon = $request -> logo_icon -> getClientOriginalName();
                $settings -> logo_icon = $request -> logo_icon -> getClientOriginalName();
                $request -> file('logo_icon') -> move('upload', $logo_icon);
                $settings -> save();
            }
            if($request -> logo_login){
                $logo_login = $request -> logo_login -> getClientOriginalName();
                $settings -> logo_login = $request -> logo_login -> getClientOriginalName();
                $request -> file('logo_login') -> move('upload', $logo_login);
                $settings -> save();
            }

        }else{
            $settings = settings::find(1);
            $settings -> site_name = $request -> site_name;
            $settings -> text_profile = $request -> text_profile;

            if($request -> send_sms_ticket_admin){
                $send_sms_ticket_admin = 1;
            }else{
                $send_sms_ticket_admin = 0;
            }

            if($request -> send_sms_ticket_client){
                $send_sms_ticket_client = 1;
            }else{
                $send_sms_ticket_client = 0;
            }

            if($request -> send_sms_ticket_reseller){
                $send_sms_ticket_reseller = 1;
            }else{
                $send_sms_ticket_reseller = 0;
            }
            if($request -> send_sms_register){
                $send_sms_register = 1;
            }else{
                $send_sms_register = 0;
            }
            if($request -> send_sms_login){
                $send_sms_login = 1;
            }else{
                $send_sms_login = 0;
            }
            

            if($request -> sms_order){
                $sms_order = 1;
            }else{
                $sms_order = 0;
            }
            if($request -> sms_goods){
                $sms_goods = 1;
            }else{
                $sms_goods = 0;
            }



            $activation_array = array([
                'send_sms_ticket_client' => $send_sms_ticket_client,
                'send_sms_ticket_admin' => $send_sms_ticket_admin,
                'send_sms_ticket_reseller' => $send_sms_ticket_reseller,
                'send_sms_register' => $send_sms_register,
                'send_sms_login' => $send_sms_login,

                'sms_order' => $sms_order,
                'sms_goods' => $sms_goods,


            ]);

            $settings -> activation = json_encode($activation_array);


            $settings -> save();
            if($request -> logo){
                $logo = $request -> logo -> getClientOriginalName();
                $settings -> logo = $request -> logo -> getClientOriginalName();
                $request -> file('logo') -> move('upload', $logo);
                $settings -> save();
            }
            if($request -> logo_icon){
                $logo_icon = $request -> logo_icon -> getClientOriginalName();
                $settings -> logo_icon = $request -> logo_icon -> getClientOriginalName();
                $request -> file('logo_icon') -> move('upload', $logo_icon);
                $settings -> save();
            }
            if($request -> logo_login){
                $logo_login = $request -> logo_login -> getClientOriginalName();
                $settings -> logo_login = $request -> logo_login -> getClientOriginalName();
                $request -> file('logo_login') -> move('upload', $logo_login);
                $settings -> save();
            }
        }
        return back()->with('success','تنظیمات پنل با موفقیت ثبت شد');
    }

}
