<?php

namespace App\Http\Middleware\Auth;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class AdminAccessMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            // ذخیره مسیر درخواست‌شده برای بازگشت بعد از لاگین
            $request->session()->put('url.intended', $request->fullUrl());
            return redirect('/login');
        }

        if (Auth::user()->account_type != 1) {
            return redirect('404');
        }

        return $next($request);
    }
}
