<?php

namespace App\Http\Middleware\Auth;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ClientAccessNotActiveMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if (!Auth::check()) {
            // ذخیره مسیر درخواست‌شده برای بازگشت بعد از لاگین
            $request->session()->put('url.intended', $request->fullUrl());
            return redirect('/login');
        }

        $user = Auth::user();

        if ($user->account_type != 2) {
            return redirect('404');
        }
        
        if ($user->active == 0) {
            Auth::logout();
            return redirect('/login')->with('error', 'نمایندگی شما مسدود شده است لطفا با پشتیبانی تماس بگیرید');
        }

        return $next($request);
    }
}
