<?php

namespace App\Models\panel;

use Verta;
use Carbon\Carbon;
use App\Models\User;
use App\Models\portal\portals;
use Illuminate\Database\Eloquent\Model;

class factor extends Model
{
    protected $table = 'factor';

    protected $casts = [
        'items_factor' => 'array',
    ];
    public function getCreatedAtAttribute($value)
    {
        //return Carbon::parse($value)->format('Y-m-d H:i:s');
        return Verta::instance($value)->format('Y-m-d H:i:s');
    }



    // فیلدهای قابل پر شدن
    protected $fillable = ['banks'];

    /**
     * تعریف Accessor برای فیلد 'banks' که بررسی می‌کند آیا عدد است یا متن
     */
    
    public function getNameBanksAttribute()
    {
        $banks = $this->banks;
        if($banks != null){
            if (is_numeric($banks)) {
                $find_portal = portals::find($banks);
                if($find_portal != null){
                    $name = $find_portal -> portal ;
                    return $name;
                }else{
                    return "-";
                }

            } elseif (is_string($banks)) {
                return $banks;
            } else {
                return '-';
            }
        }
        return '-';
    }

    public function getArrayUserAttribute()
    {
        $client_id = $this->client_id;
        $find_user = User::find($client_id);
        if($find_user != null){
            return $find_user;
        }else{
            return "-";
        }
        return '-';
    }



        public function scopeSettlementStatusCustom($query)
        {
            return $query->orderByRaw("
                CASE 
                    WHEN JSON_EXTRACT(items_factor, '$.StatusSend') = 2 THEN 1
                    WHEN JSON_EXTRACT(items_factor, '$.StatusSend') = 1 THEN 2
                    WHEN JSON_EXTRACT(items_factor, '$.StatusSend') = 3 THEN 3
                    ELSE 4
                END
            ");
        }



    public function getTextFactorAttribute()
    {
        $name_factor = $this->name_factor;
        $items_factor = $this->items_factor;

        if($name_factor == "factorCampaign"){
            $text = 'حمایت از کمپین'.' ( '.$items_factor['campaign']['name'].' ) ';
            return $text;
        }elseif($name_factor == "factorSubsidy"){
            return 'حمایت مالی';
        }elseif($name_factor == "factorProduct"){
            return 'سفارش محصول';
        }else{
            return '-';
        }
        return '-';
    }












    protected $appends = ['name_banks','text_factor','array_user'];















    
    public function user()
    {
        return $this->belongsTo(User::class, 'client_id');
    }

}
