<?php

namespace App\Models\panel;
use Verta;
use Carbon\Carbon;


use App\Models\panel\department;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;




class ticket extends Model
{
    use HasFactory;

    protected $table = 'ticket';

    public function getCreatedAtAttribute($value)
    {
        //return Carbon::parse($value)->format('Y-m-d H:i:s');
        return Verta::instance($value)->format('Y-m-d H:i:s');
    }





    public function getTextDepartmentAttribute()
    {
        $department = $this->attributes['department'];

        $find_department = department::find($department);
        if($find_department != null){
            $name = $find_department -> name ;
            return $name;
        }else{
            return "-";
        }
    }

    
    public function getTextStatusAttribute()
    {
        $status = $this->attributes['status'];
        if($status == 1){
            return "باز";
        }elseif($status == 2){
            return "بسته";
        }elseif($status == 3){
            return "در انتظار پاسخ";
        }elseif($status == 4){
            return "پاسخ داده شده";
        }elseif($status == 5){
            return "در حال رسیدگی";
        }else{
            return "از طرف ادمین";
        }
    }

    public function getDateAgoAttribute()
    {
        $type = $this->attributes['created_at'];
        $varta = new \Verta($type);
        $time = $varta ->formatDifference();
        return $time;
    }

    protected $appends = ['textDepartment','textStatus','date_ago'];

}
