<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class Factor extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('factor', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name_factor');
            $table->string('phone')-> nullable();
            $table->string('name')-> nullable();
            $table->string('client_id')-> nullable();
            $table->text('items_factor')-> nullable();
            $table->string('transition_port')-> nullable();
            $table->string('price')-> nullable();//قیمت پرداخت
            $table->boolean('payment')->default(0);//آیا پرداخت شده یا نه
            $table->string('banks')-> nullable();
            $table->string('type_name')-> nullable();
            $table->string('campaign_id')-> nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('factor');
    }
}
