﻿@extends('layouts/client/header')
@section('title', 'همه دسته بندی کمپین ها')
@section('content')

<style>
.border-hover-primary {
    border: 1px solid white;
}
.border-hover-primary:hover {
    border-color: var(--bs-primary) !important;
}
</style>

<div class="row">



	<div class="col-lg-2 col-xl-2 col-xxl-2 mb-5 mb-xl-0 card">
		@foreach($CategoryCampaign as $item_CategoryCampaign)
			<a href="{{url('client/searchCategoryCampaign'.'/'.$item_CategoryCampaign -> id)}}">
				<div class="card-header border-0 pt-5">
					<h3 class="card-title align-items-start flex-column">
						<span class="card-label fw-bold text-dark">دسته بندی ها</span>
						<span class="text-muted mt-1 fw-semibold fs-7">کل کمپین های فعال ( {{$count_campaignok}} عدد )</span>
					</h3>
				</div>
				<div class="card-body pt-7 px-0">
					<div class="tab-content mb-2 px-9">
						<div class="tab-pane fade show active" id="kt_timeline_widget_3_tab_content_4" role="tabpanel">
							<div class="d-flex align-items-center mb-6">
								<span data-kt-element="bullet" class="bullet bullet-vertical d-flex align-items-center min-h-30px  me-4 bg-info"></span>
								<div class="flex-grow-1 me-5">
									<div class="text-gray-800 fw-semibold fs-4">{{$item_CategoryCampaign -> name}}</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</a>
		@endforeach

	</div>










	<div class="col-md-10 col-xl-10">
		<div class="row">
			@foreach ($campaign as $item_Campaign)
				<div class="col-md-6 col-xl-4">
					<a href="{{url('client/campaign'.'/'.$item_Campaign -> id)}}" class="card border-hover-primary">
						<div class="card-header border-0 pt-9">
							<div class="card-title m-0" style="width: 100%;">
								<div style="margin: 0 auto">
									<img src="{{url("upload/Campaign")."/". $item_Campaign->image}}" alt="image" class="p-3" style="width:100%;border-radius: 15px !important;">
								</div>
							</div>
						</div>
						<div class="card-body p-9">
							@php
								$ProgressPercent = $item_Campaign->array_factor['ProgressPercent'];
								if($ProgressPercent <= 40){
									$background = 'bg-danger';
									$text = 'در حال جمع آوری';
									$background_span = 'primary';
								}elseif($ProgressPercent <= 99){
									$background = 'bg-primary';
									$text = 'در حال جمع آوری';
									$background_span = 'primary';
								}else{
									$background = 'bg-success';
									$text = 'موفق';
									$background_span = 'success';
								}
							@endphp


							<div style="display: flex;justify-content: space-between;">
								<div>
									<div class="fs-3 fw-bold text-dark">{{ $item_Campaign->name }}</div>
									<p class="text-gray-400 fw-semibold fs-5 mt-1 mb-7">{{ $item_Campaign->name_category }}</p>
								</div>

								<div class="card-toolbar">
									@if ($item_Campaign->status == 1)
										<span class="badge badge-light-{{$background_span}} fw-bold me-auto px-4 py-3">{{$text}}</span>

									@else
									
										@if ($item_Campaign->status == 2)
											<span class="badge badge-light-success fw-bold me-auto px-4 py-3">تمام شده</span>
										@elseif($item_Campaign->status == 3)
											<span class="badge badge-light-danger fw-bold me-auto px-4 py-3">کنسل شده</span>
										@else
											<span class="badge badge-light-danger fw-bold me-auto px-4 py-3">لغو شده</span>
										@endif

									@endif

								</div>
							</div>



							<div class="d-flex flex-wrap mb-5"></div>

							<div class="d-flex justify-content-between fw-bold fs-6 text-gray-400 w-100 mt-auto mb-2">
								<span>پیشرفت</span>
								<span>{{$ProgressPercent}}%</span>
							</div>
							<!--  bg-success  bg-danger   -->
							<div class="h-4px w-100 bg-light mb-5" data-bs-toggle="tooltip" aria-label="This project {{$ProgressPercent}}% completed" data-bs-original-title="This project 50% completed" data-kt-initialized="1">

								<div class="{{$background}} rounded h-4px" role="progressbar" style="width: {{$ProgressPercent}}%" aria-valuenow="{{$ProgressPercent}}" aria-valuemin="0" aria-valuemax="100"></div>
							</div>
							<div class="symbol-group symbol-hover">
								@foreach ($item_Campaign->array_factor['TopSupporters'] as $item_TopSupporters)
									<div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" aria-label="{{$item_TopSupporters->user->name}}" data-bs-original-title="{{$item_TopSupporters->user->name}}" data-kt-initialized="{{$item_TopSupporters->user->id}}">
										<img alt="Pic" src="{{url('upload'.'/'.$item_TopSupporters->user -> avatar)}}">
									</div>
								@endforeach
								<div class="symbol symbol-35px symbol-circle" data-bs-toggle="tooltip" data-bs-original-title="+{{number_format($item_Campaign->array_factor['SupportersCount'])}}" data-kt-initialized="1" aria-describedby="tooltip285458">
									<span class="symbol-label bg-dark text-inverse-dark fw-bold">+{{number_format($item_Campaign->array_factor['SupportersCount'])}}</span>
								</div>


							</div>
						</div>
					</a>
				</div>
			@endforeach


		</div>


			<div class="card" style="margin-top: 10px;">
				{{ $campaign->links('layouts.others.pagination') }}
			</div>

	</div>


</div>


@endsection
