@extends('layouts/client/header')
@section('title', 'داشبورد')
@section('content')
@php
    use App\Models\User;
    use Illuminate\Support\Str;
    use App\Models\panel\department;
@endphp


<style>
.icon-white svg path{fill: white !important;}
.flex-center
{
    display: flex;
    justify-content: center;
}

</style>

@if (\Auth::user() -> active == 2)
    
    <div class="col-lg-12">
        <div class="card card-custom gutter-b  example-compact">
            <div class="card-header">
                <h5 class="card-title">
                    تایید شماره موبایل
                </h5>
            </div>
            <!--begin::Form-->
            <form class="form-horizontal" method="POST" action="{{ url('client/checkCodeSend') }}">
                {{ csrf_field() }}
                <div class="card-body pad-top-0">
                    <div class="form-group row">
                        <label class="col-4 col-form-label">شماره ثبت شده:</label>
                        <div class="col-8">
                            <span class="form-control-plaintext font-weight-bolder newfont">
                                {{\Auth::user() -> phone}}
                            </span>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-lg-12 form-group mb-3">
                            <label class="mb-3">کد ارسال شده</label>
                            <input id="code" type="text" class="form-control" name="code" placeholder="کد ارسال شده">
                        </div>
                    </div>

                </div>
                <div class="card-footer">
                    <input type="submit" class="btn btn-primary mr-2 nbbtn" name="confirmation" value="تایید شماره"/>
                    <input type="submit" class="btn btn-warning mr-2 nbbtn" name="sendCode" value="ارسال کد"/>
                </div>
            </form>
            <!--end::Form-->
        </div>
    </div>
@else

<div class="row g-5 g-xl-10 mb-5 mb-xl-10">

	@foreach($newsindexs as $item)
    <div class="card card-custom table-responsive">
    		<div class="card-header flex-wrap ">
    			<div class="card-title" style="display: flex;justify-content: flex-start;width: 100%;">
                    <img src="{{ URL::asset('assets/panel/media/newsvg/envelope_mail_message_email_icon.svg')}}" style="width: 35px;height: 35px;" />
    				<h5 class="card-label">
    					{{$item -> title}}
    				</h5>
    			</div>
    		</div>
    		<div class="card-body pad-top-0">
                <pre style="font-family: Iransans;overflow: hidden;font-size: 14px;padding:0;">{{$item -> description}}</pre>
    		</div>
    </div>
    @endforeach















    <!--begin::Col-->
    <div class="col-xl-3">
        <!--begin::کارت widget 3-->
        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end h-xl-100" style="background-color: #543a39">
            <!--begin::Header-->
            <div class="card-header pt-5 mb-3">
                <!--begin::Icon-->
                <div class="d-flex flex-center rounded-circle h-80px w-80px icon-white" style="border: 1px dashed rgba(255, 255, 255, 0.4);background-color: #543a39">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.0021 10.9128V3.01281C13.0021 2.41281 13.5021 1.91281 14.1021 2.01281C16.1021 2.21281 17.9021 3.11284 19.3021 4.61284C20.7021 6.01284 21.6021 7.91285 21.9021 9.81285C22.0021 10.4129 21.5021 10.9128 20.9021 10.9128H13.0021Z" fill="currentColor"></path>
                            <path opacity="0.3" d="M11.0021 13.7128V4.91283C11.0021 4.31283 10.5021 3.81283 9.90208 3.91283C5.40208 4.51283 1.90209 8.41284 2.00209 13.1128C2.10209 18.0128 6.40208 22.0128 11.3021 21.9128C13.1021 21.8128 14.7021 21.3128 16.0021 20.4128C16.5021 20.1128 16.6021 19.3128 16.1021 18.9128L11.0021 13.7128Z" fill="currentColor"></path>
                            <path opacity="0.3" d="M21.9021 14.0128C21.7021 15.6128 21.1021 17.1128 20.1021 18.4128C19.7021 18.9128 19.0021 18.9128 18.6021 18.5128L13.0021 12.9128H20.9021C21.5021 12.9128 22.0021 13.4128 21.9021 14.0128Z" fill="currentColor"></path>
                        </svg>
                </div>
                <!--end::Icon-->
            </div>
            <!--end::Header-->
            <!--begin::کارت body-->
            <div class="card-body d-flex align-items-end mb-3">
                <!--begin::Info-->
                <div class="d-flex align-items-center">
                    <span class="fs-4hx text-white fw-bold me-6">{{count($factorCampaign)}}</span>
                    <div class="fw-bold fs-6 text-white">
                        <span class="d-block">تعداد کمپین های</span>
                        <span class="">شرکت شده </span>
                    </div>
                </div>
                <!--end::Info-->
            </div>
            <!--end::کارت body-->
            <!--begin::کارت footer-->
            <div class="card-footer" style="border-top: 1px solid rgba(255, 255, 255, 0.3);background: rgba(0, 0, 0, 0.15);">
                <!--begin::پردازش-->
                <div class="fw-bold text-white py-2">
                    <span class="fs-1 d-block">{{ number_format(array_sum($factorCampaign-> pluck('price')->toArray())) }}</span>
                    <span class="opacity-50">تومان</span>
                </div>
                <!--end::پردازش-->
            </div>
            <!--end::کارت footer-->
        </div>
        <!--end::کارت widget 3-->
    </div>
    <!--end::Col-->










    <!--begin::Col-->
    <div class="col-xl-3">
        <!--begin::کارت widget 3-->
        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end h-xl-100" style="background-color: #4b5439">
            <!--begin::Header-->
            <div class="card-header pt-5 mb-3">
                <!--begin::Icon-->
                <div class="d-flex flex-center rounded-circle h-80px w-80px icon-white" style="border: 1px dashed rgba(255, 255, 255, 0.4);background-color: #4b5439">
                    <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M20 19.725V18.725C20 18.125 19.6 17.725 19 17.725H5C4.4 17.725 4 18.125 4 18.725V19.725H3C2.4 19.725 2 20.125 2 20.725V21.725H22V20.725C22 20.125 21.6 19.725 21 19.725H20Z" fill="currentColor"></path>
                        <path opacity="0.3" d="M22 6.725V7.725C22 8.325 21.6 8.725 21 8.725H18C18.6 8.725 19 9.125 19 9.725C19 10.325 18.6 10.725 18 10.725V15.725C18.6 15.725 19 16.125 19 16.725V17.725H15V16.725C15 16.125 15.4 15.725 16 15.725V10.725C15.4 10.725 15 10.325 15 9.725C15 9.125 15.4 8.725 16 8.725H13C13.6 8.725 14 9.125 14 9.725C14 10.325 13.6 10.725 13 10.725V15.725C13.6 15.725 14 16.125 14 16.725V17.725H10V16.725C10 16.125 10.4 15.725 11 15.725V10.725C10.4 10.725 10 10.325 10 9.725C10 9.125 10.4 8.725 11 8.725H8C8.6 8.725 9 9.125 9 9.725C9 10.325 8.6 10.725 8 10.725V15.725C8.6 15.725 9 16.125 9 16.725V17.725H5V16.725C5 16.125 5.4 15.725 6 15.725V10.725C5.4 10.725 5 10.325 5 9.725C5 9.125 5.4 8.725 6 8.725H3C2.4 8.725 2 8.325 2 7.725V6.725L11 2.225C11.6 1.925 12.4 1.925 13.1 2.225L22 6.725ZM12 3.725C11.2 3.725 10.5 4.425 10.5 5.225C10.5 6.025 11.2 6.725 12 6.725C12.8 6.725 13.5 6.025 13.5 5.225C13.5 4.425 12.8 3.725 12 3.725Z" fill="currentColor"></path>
                    </svg>
                </div>
                <!--end::Icon-->
            </div>
            <!--end::Header-->
            <!--begin::کارت body-->
            <div class="card-body d-flex align-items-end mb-3">
                <!--begin::Info-->
                <div class="d-flex align-items-center">
                    <span class="fs-4hx text-white fw-bold me-6">{{count($factorSubsidy)}}</span>
                    <div class="fw-bold fs-6 text-white">
                        <span class="d-block">تعداد حمایت مالی های</span>
                        <span class="">انجام شده </span>
                    </div>
                </div>
                <!--end::Info-->
            </div>
            <!--end::کارت body-->
            <!--begin::کارت footer-->
            <div class="card-footer" style="border-top: 1px solid rgba(255, 255, 255, 0.3);background: rgba(0, 0, 0, 0.15);">
                <!--begin::پردازش-->
                <div class="fw-bold text-white py-2">
                    <span class="fs-1 d-block">{{ number_format(array_sum($factorSubsidy-> pluck('price')->toArray())) }}</span>
                    <span class="opacity-50">تومان</span>
                </div>
                <!--end::پردازش-->
            </div>
            <!--end::کارت footer-->
        </div>
        <!--end::کارت widget 3-->
    </div>
    <!--end::Col-->










    <!--begin::Col-->
    <div class="col-xl-3">
        <!--begin::کارت widget 3-->
        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end h-xl-100" style="background-color: #ea3939">
            <!--begin::Header-->
            <div class="card-header pt-5 mb-3">
                <!--begin::Icon-->
                <div class="d-flex flex-center rounded-circle h-80px w-80px icon-white" style="border: 1px dashed rgba(255, 255, 255, 0.4);background-color: #ea3939">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path fill="currentColor" d="M21 10H13V11C13 11.6 12.6 12 12 12C11.4 12 11 11.6 11 11V10H3C2.4 10 2 10.4 2 11V13H22V11C22 10.4 21.6 10 21 10Z" fill="currentColor"></path>
                        <path fill="currentColor" opacity="0.3" d="M12 12C11.4 12 11 11.6 11 11V3C11 2.4 11.4 2 12 2C12.6 2 13 2.4 13 3V11C13 11.6 12.6 12 12 12Z" fill="currentColor"></path>
                        <path fill="currentColor" opacity="0.3" d="M18.1 21H5.9C5.4 21 4.9 20.6 4.8 20.1L3 13H21L19.2 20.1C19.1 20.6 18.6 21 18.1 21ZM13 18V15C13 14.4 12.6 14 12 14C11.4 14 11 14.4 11 15V18C11 18.6 11.4 19 12 19C12.6 19 13 18.6 13 18ZM17 18V15C17 14.4 16.6 14 16 14C15.4 14 15 14.4 15 15V18C15 18.6 15.4 19 16 19C16.6 19 17 18.6 17 18ZM9 18V15C9 14.4 8.6 14 8 14C7.4 14 7 14.4 7 15V18C7 18.6 7.4 19 8 19C8.6 19 9 18.6 9 18Z" fill="currentColor"></path>
                    </svg>
                </div>
                <!--end::Icon-->
            </div>
            <!--end::Header-->
            <!--begin::کارت body-->
            <div class="card-body d-flex align-items-end mb-3">
                <!--begin::Info-->
                <div class="d-flex align-items-center">
                    <span class="fs-4hx text-white fw-bold me-6">{{count($factorProduct->where('payment',1))}}</span>
                    <div class="fw-bold fs-6 text-white">
                        <span class="d-block">محصولات</span>
                        <span class="">خریداری شده</span>
                    </div>
                </div>
                <!--end::Info-->
            </div>
            <!--end::کارت body-->
            <!--begin::کارت footer-->
            <div class="card-footer" style="border-top: 1px solid rgba(255, 255, 255, 0.3);background: rgba(0, 0, 0, 0.15);">
                <!--begin::پردازش-->
                <div class="fw-bold text-white py-2">
                    <span class="fs-1 d-block">{{ number_format(array_sum($factorProduct->where('payment',1)-> pluck('price')->toArray())) }}</span>
                    <span class="opacity-50">تومان</span>
                </div>
                <!--end::پردازش-->
            </div>
            <!--end::کارت footer-->
        </div>
        <!--end::کارت widget 3-->
    </div>
    <!--begin::Col-->












    <!--begin::Col-->
    <div class="col-xl-3">
        <!--begin::کارت widget 3-->
        <div class="card card-flush bgi-no-repeat bgi-size-contain bgi-position-x-end h-xl-100" style="background-color: #02868b">
            <!--begin::Header-->
            <div class="card-header pt-5 mb-3">
                <!--begin::Icon-->
                <div class="d-flex flex-center rounded-circle h-80px w-80px icon-white" style="border: 1px dashed rgba(255, 255, 255, 0.4);background-color: #02868b">
                    <svg width="30" height="30" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path opacity="0.3" d="M21 19H3C2.4 19 2 18.6 2 18V6C2 5.4 2.4 5 3 5H21C21.6 5 22 5.4 22 6V18C22 18.6 21.6 19 21 19Z" fill="currentColor"></path>
                        <path d="M21 5H2.99999C2.69999 5 2.49999 5.10005 2.29999 5.30005L11.2 13.3C11.7 13.7 12.4 13.7 12.8 13.3L21.7 5.30005C21.5 5.10005 21.3 5 21 5Z" fill="currentColor"></path>
                    </svg>
                </div>
                <!--end::Icon-->
            </div>
            <!--end::Header-->
            <!--begin::کارت body-->
            <div class="card-body d-flex align-items-end mb-3">
                <!--begin::Info-->
                <div class="d-flex align-items-center">
                    <span class="fs-4hx text-white fw-bold me-6">{{$allTicket}}</span>
                    <div class="fw-bold fs-6 text-white">
                        <span class="d-block">کل تیکت های</span>
                        <span class="">ایجاد شده</span>
                    </div>
                </div>
                <!--end::Info-->
            </div>
            <!--end::کارت body-->
            <!--begin::کارت footer-->
            <div class="card-footer" style="border-top: 1px solid rgba(255, 255, 255, 0.3);background: rgba(0, 0, 0, 0.15);">
                <!--begin::پردازش-->
                <div class="fw-bold text-white py-2">
                    <span class="fs-1 d-block">{{$allTicket}}</span>
                    <span class="opacity-50">عدد</span>
                </div>
                <!--end::پردازش-->
            </div>
            <!--end::کارت footer-->
        </div>
        <!--end::کارت widget 3-->
    </div>
    <!--end::Col-->





















<div class="col-lg-12">


	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					آخرین سفارشات
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره فاکتور</th>
						<th>نام سفارش</th>
						<th>مبلغ</th>
						<th>درگاه</th>
						<th>وضعیت</th>
						<th>وضعیت سفارش</th>
						<th>تاریخ صدور فاکتور</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($factorProduct -> take(10) as $item_allOrder)
						<tr>
							<td>{{$item_allOrder->id}} #</td>
							<td>{{$item_allOrder->text_factor}}</td>
							<td>{{ number_format($item_allOrder->price) }} تومان</td>
							<td>
								<span class="badge badge-light-warning nback">{{$item_allOrder->name_banks}}</span>
							</td> 
							<td>
								@if($item_allOrder->payment == 0)
									<span class="badge badge-light-warning nback">پرداخت نشده</span>
								@elseif($item_allOrder->payment == 1)
									<span class="badge badge-light-success nback">پرداخت شده</span>
								@elseif($item_allOrder->payment == 3)
									<span class="badge badge-light-danger nback">پس داده شده</span>
								@else
									<span class="badge badge-light-danger nback">لغو شده</span>
								@endif
							</td>
							<td>
								@if($item_allOrder->payment == 1)
									@if($item_allOrder->items_factor['StatusSend'] == 1)
										<span class="badge badge-light-success nback">ارسال شده</span>
									@elseif($item_allOrder->items_factor['StatusSend'] == 2)
										<span class="badge badge-light-warning nback">در دست برسی</span>
									@else
										<span class="badge badge-light-danger nback">لغو شده</span>
									@endif
								@else
									<span class="badge badge-light-danger nback">پرداخت نشده</span>
								@endif

							</td>



							<td>
								{{$item_allOrder -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('client/factor') . '/' . $item_allOrder->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="نمایش">
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"/>
												<path d="M13,5 L15,5 L15,20 L13,20 L13,5 Z M5,5 L5,20 L3,20 C2.44771525,20 2,19.5522847 2,19 L2,6 C2,5.44771525 2.44771525,5 3,5 L5,5 Z M16,5 L18,5 L18,20 L16,20 L16,5 Z M20,5 L21,5 C21.5522847,5 22,5.44771525 22,6 L22,19 C22,19.5522847 21.5522847,20 21,20 L20,20 L20,5 Z" fill="#000000"/>
												<polygon fill="#000000" opacity="0.3" points="9 5 9 20 7 20 7 5"/>
											</g>
										</svg>
									</span>
								</a>
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
	</div>
</div>












































<div class="col-lg-12">


	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					آخرین کمپین های شرکت شده
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره فاکتور</th>
						<th>نام کمپین</th>
						<th>مبلغ</th>
						<th>درگاه</th>
						<th>وضعیت</th>
						<th>تاریخ صدور فاکتور</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($factorCampaign -> take(10) as $item_charge_wallet)
						<tr>
							<td>{{$item_charge_wallet->id}} #</td>
							<td>{{$item_charge_wallet->text_factor}}</td>
							<td>{{ number_format($item_charge_wallet->price) }} تومان</td>
							<td>
								<span class="badge badge-light-warning nback">{{$item_charge_wallet->name_banks}}</span>
							</td> 
							<td>
								@if($item_charge_wallet->payment == 0)
									<span class="badge badge-light-warning nback">پرداخت نشده</span>
								@elseif($item_charge_wallet->payment == 1)
									<span class="badge badge-light-success nback">پرداخت شده</span>
								@elseif($item_charge_wallet->payment == 3)
									<span class="badge badge-light-danger nback">پس داده شده</span>
								@else
									<span class="badge badge-light-danger nback">لغو شده</span>
								@endif
							</td>
							
							<td>
								{{$item_charge_wallet -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('client/factor') . '/' . $item_charge_wallet->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="نمایش">
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"/>
												<path d="M13,5 L15,5 L15,20 L13,20 L13,5 Z M5,5 L5,20 L3,20 C2.44771525,20 2,19.5522847 2,19 L2,6 C2,5.44771525 2.44771525,5 3,5 L5,5 Z M16,5 L18,5 L18,20 L16,20 L16,5 Z M20,5 L21,5 C21.5522847,5 22,5.44771525 22,6 L22,19 C22,19.5522847 21.5522847,20 21,20 L20,20 L20,5 Z" fill="#000000"/>
												<polygon fill="#000000" opacity="0.3" points="9 5 9 20 7 20 7 5"/>
											</g>
										</svg>
									</span>
								</a>


							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
	</div>
</div>























<div class="col-lg-12">
	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h3 class="card-label">
					آخرین حمایت مالی ها
				</h3>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره فاکتور</th>
						<th>نام و نام خانوادگی</th>
						<th>شماره موبایل</th>
						<th>مبلغ</th>
						<th>وضعیت</th> 
						<th>تاریخ صدور فاکتور</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($factorSubsidy -> take(10) as $item_factor)
						<tr>
							<td>#{{ $item_factor->id }}</td>
							<td>{{ $item_factor->array_user->name }}</td>
							<td>{{ $item_factor->array_user->phone }}</td>
							<td>{{ number_format($item_factor->price) }} تومان</td>
							<td style="padding-top: 20px;">
								@if($item_factor->payment == 0)
									<span class="badge badge-light-warning nback">پرداخت نشده</span>
								@elseif($item_factor->payment == 1)
									<span class="badge badge-light-success nback">پرداخت شده</span>
								@elseif($item_factor->payment == 3)
									<span class="badge badge-light-danger nback">پس داده شده</span>
								@else
									<span class="badge badge-light-danger nback">لغو شده</span>
								@endif
							</td> 
							<td>
								{{$item_factor -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('client/factor') . '/' . $item_factor->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="نمایش">
									<span class="">
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"/>
												<path d="M13,5 L15,5 L15,20 L13,20 L13,5 Z M5,5 L5,20 L3,20 C2.44771525,20 2,19.5522847 2,19 L2,6 C2,5.44771525 2.44771525,5 3,5 L5,5 Z M16,5 L18,5 L18,20 L16,20 L16,5 Z M20,5 L21,5 C21.5522847,5 22,5.44771525 22,6 L22,19 C22,19.5522847 21.5522847,20 21,20 L20,20 L20,5 Z" fill="#000000"/>
												<polygon fill="#000000" opacity="0.3" points="9 5 9 20 7 20 7 5"/>
											</g>
										</svg>
									</span>
								</a>
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
	</div>
</div>






























</div>








@endif







	@section('script')

		<script>




		</script>

		
	@endsection

@endsection
