﻿@extends('layouts/panel/header')
@section('title', 'همه کمپین ها')
@section('content')
<div class="col-lg-12">
	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h3 class="card-label">
					همه کمپین ها
				</h3>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<span class="linkdelete" style="display: none">{{url('panel/deleteCampaign')}}</span>
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>ID</th>
						<th>عکس</th>
						<th>نام</th>
						<th>نام دسته بندی</th>
						<th>وضعیت</th> 
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($Campaign as $item_Campaign)
						<tr>
							<td>#{{ $item_Campaign->id }}</td>
							<td><img src="{{url("upload/Campaign")."/". $item_Campaign->image}}" style="width: 50px"/></td>
							<td>{{ $item_Campaign->name }}</td>
							<td>{{ $item_Campaign->name_category }}</td>

							<td style="padding-top: 20px;">
								@if ($item_Campaign -> status == 1)
									<span class="badge badge-light-success fw-bold nback">فعال</span>
								@elseif($item_Campaign -> status == 2)
									<span class="badge badge-light-success fw-bold nback">تمام شده</span>
								@elseif($item_Campaign -> status == 3)
									<span class="badge badge-light-danger fw-bold nback">کنسل شده</span>
								@else
									<span class="badge badge-light-danger fw-bold nback">غیر فعال</span>
								@endif
							</td> 

							<td class="delete-content">

								<a href="{{ url('panel/profileCampaign') . '/' . $item_Campaign->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="پروفایل">
									<span> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
										<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
											<rect x="0" y="0" width="24" height="24"></rect>
											<path fill="currentColor" d="M3.5,21 L20.5,21 C21.3284271,21 22,20.3284271 22,19.5 L22,8.5 C22,7.67157288 21.3284271,7 20.5,7 L10,7 L7.43933983,4.43933983 C7.15803526,4.15803526 6.77650439,4 6.37867966,4 L3.5,4 C2.67157288,4 2,4.67157288 2,5.5 L2,19.5 C2,20.3284271 2.67157288,21 3.5,21 Z" fill="#000000" opacity="0.3"></path>
											<path fill="currentColor" d="M12,13 C10.8954305,13 10,12.1045695 10,11 C10,9.8954305 10.8954305,9 12,9 C13.1045695,9 14,9.8954305 14,11 C14,12.1045695 13.1045695,13 12,13 Z" fill="#000000" opacity="0.3"></path>
											<path fill="currentColor" d="M7.00036205,18.4995035 C7.21569918,15.5165724 9.36772908,14 11.9907452,14 C14.6506758,14 16.8360465,15.4332455 16.9988413,18.5 C17.0053266,18.6221713 16.9988413,19 16.5815,19 C14.5228466,19 11.463736,19 7.4041679,19 C7.26484009,19 6.98863236,18.6619875 7.00036205,18.4995035 Z" fill="#000000" opacity="0.3"></path>
										</g>
									</svg> </span>
								</a>


								<a href="{{ url('panel/editCampaign') . '/' . $item_Campaign->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="ویرایش">
									<span class=""> <svg xmlns="http://www.w3.org/2000/svg"
											xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
											viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"></rect>
												<path fill="currentColor"
													d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
													fill="#000000" fill-rule="nonzero"
													transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) ">
												</path>
												<rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2"
													rx="1"></rect>
											</g>
										</svg> </span>
								</a>


								<a class="btn btn-sm btn-clean btn-icon btns-delete" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="حذف">
									<span class=""> 
										<svg xmlns="http://www.w3.org/2000/svg"
											xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
											viewBox="0 0 24 24" version="1.1">
											<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
												<rect x="0" y="0" width="24" height="24"></rect>
												<path fill="currentColor"
													d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
													fill="#000000" fill-rule="nonzero"></path>
												<path fill="currentColor"
													d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
													fill="#000000" opacity="0.3"></path>
											</g>
										</svg> 
									</span>
								</a>
								<input type="text" class="value-delete" style="display:none" value="{{$item_Campaign -> id}}" />
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $Campaign->links('layouts.others.pagination') }}
		</div>
	</div>
</div>

    <div class="swal2-container swal2-rtl swal2-center swal2-backdrop-show box-delete" style="display:none" style="overflow-y: auto;">
      <div aria-labelledby="swal2-title" aria-describedby="swal2-html-container" class="swal2-popup swal2-modal swal2-icon-error swal2-show" tabindex="-1" role="dialog" aria-live="assertive" aria-modal="true" style="display: grid;">
            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;"><div class="swal2-icon-content">!</div></div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">آیا مطمئن هستید؟</div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">درصورت حذف امکان بازگردانی جود ندارد!</div>
      <div class="swal2-actions" style="display: flex;margin-bottom: 30px;">
      <div class="swal2-loader"></div>

        <button class="swal2-confirm btn btn-danger btns-delete-cancele" aria-label="" style="display: inline-block;margin:0" >نه کنسل کن</button>
        <div class="swal-button-container">
            <form action="" method="POST" class="form-delete" style="margin:0">
                {{method_field('delete')}}
                {{ csrf_field()}}
                <button class="swal2-confirm btn btn-success" style="margin-top: 0">بله حذف کن</button>
            </form>
        </div>

      </div>
      </div>
      </div>

@endsection
