@extends('layouts/panel/header')
@section('title', ' به کاربر ها')
@section('content')

    <div class="col-lg-12">
        <form action="accessClient" method="post" enctype="multipart/form-data">
            {{ csrf_field() }}
        <div class="card card-custom table-responsive">
            <div class="card-header flex-wrap py-5">
                <div class="card-title">
                    <h3 class="card-label">
                         به نمایند ها
                    </h3>
                </div>
                <div>

                    <div id="active_sms" class="btn btn-info font-weight-bolder font-size-sm mr-3">همه ارسال پیامک</div>
                </div>
            </div>
            <div class="card-body">
                <!--begin: جدول داده ها-->
                <table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
                    <thead>
                        <tr>
							<th>نام کاربر</th> 
							<th>ایمیل</th> 
							<th>انتخاب </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($all_user as $item_client)
                            <tr>
								<td style="display: none"><input type="number" name="id_client[]" value="{{$item_client -> id}}"></td> 
								<td style="padding-top: 15px;">{{$item_client -> name}}</td> 
								<td style="padding-top: 15px;">{{$item_client -> email}}</td> 
                                <td class="delete-content">
                                    <div class="col-form-label">
                                        <div class="checkbox-inline" style="display: flex;justify-content: center;">
                                        

                                            <div class="boxses" style="margin-left: 15px;">
                                                <input style="display: none" type="number" class="active_sms" name="active_sms[]" value="{{ $item_client -> active_sms }}">
                                                <div class="form-check form-check-inline checkbox checkbox-primary">
                                                    <input class="form-check-input checkboxes checkbox_sms check_active" type="checkbox" @if($item_client -> active_sms == 1) checked @endif>
                                                    <label class="form-check-label">ارسال پیامک</label>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                </table>
                <!--end: جدول داده ها-->
                <div class="card-footer" style="padding-right: 0;padding-bottom: 0;display: flex;justify-content: space-between;">
                    <div>
                        <button class="btn btn-primary mr-2">ثبت</button>
                        <a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
                    </div>

                </div>

            </div>
        </div>
        </form>
    </div>
    @section('script')





        <script>
            $(".check_active").on("click", function() {
                if($(this).prop('checked') == true){
                    $('.boxses').removeClass('active');
                    $(this).parent().parent().addClass('active');
                    $('.boxses.active > input').val(1);
                }else{
                    $('.boxses').removeClass('active');
                    $(this).parent().parent().addClass('active');
                    $('.boxses.active > input').val(0);
                }
            });


            $("#active_sms").on("click", function() {
                if($(this).hasClass("active")){
                    $(this).removeClass('active');
                    $('input.active_sms').val(1);
                    $(".checkbox_sms").prop('checked', true);
                }else{
                    $(this).addClass('active');
                    $('input.active_sms').val(0);
                    $(".checkbox_sms").prop('checked', false);
                }
            });

            
        </script>
    @endsection
@endsection
