@extends('layouts/panel/header')
@section('title', 'همه خبر ها')
@section('content')
    <div class="col-lg-12">
        <div class="card card-custom table-responsive">
            <div class="card-header flex-wrap ">
                <div class="card-title">
                    <h3 class="card-label">
                        همه خبر ها
                    </h3>
                </div>
            </div>
            <div class="card-body pad-top-0">
                <span class="linkdelete" style="display: none">{{url('panel/deleteNews')}}</span>
                <!--begin: جدول داده ها-->
                <table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
                    <thead>
                        <tr>
							<th>عنوان اخبار</th> 
							<th>توضیحات</th> 
							<th>نمایش</th> 
							<th>نمایش در صفحه اصلی</th> 
							<th>تاریخ</th> 
							<th>عملیات</th> 
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($all_user as $item_user)
                            <tr>
								<td>{{$item_user -> title}}</td> 
								<td>{{\Illuminate\Support\Str::limit($item_user -> description, 30)}}</td> 
								<td>
									@if ($item_user -> show_user == 1)
										 نمایش به نمایند ها
									@elseif ($item_user -> show_user == 2)
										نمایش به نماینده مستر ها
									@else
										نمایش به همه
									@endif
								</td> 
                                <td>
                                    @if($item_user -> indexs == 1)
                                        <span class="badge badge-light-success fw-bold" style="font-size: 13px !important;padding: 10px 20px 10px 20px;">بله</span>
                                    @else
                                        <span class="badge badge-light-danger fw-bold" style="font-size: 13px !important;padding: 10px 20px 10px 20px;">خیر</span>
                                    @endif
                                </td> 
                                <td>
                                    {{$item_user -> created_at}}
                                </td>
                                <td class="delete-content">
                                    <a href="{{ url('panel/editNews') . '/' . $item_user->id }}"
                                        class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="ویرایش">
                                        <span> <svg xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                                viewBox="0 0 24 24" version="1.1">
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <rect x="0" y="0" width="24" height="24"></rect>
                                                    <path
                                                        d="M8,17.9148182 L8,5.96685884 C8,5.56391781 8.16211443,5.17792052 8.44982609,4.89581508 L10.965708,2.42895648 C11.5426798,1.86322723 12.4640974,1.85620921 13.0496196,2.41308426 L15.5337377,4.77566479 C15.8314604,5.0588212 16,5.45170806 16,5.86258077 L16,17.9148182 C16,18.7432453 15.3284271,19.4148182 14.5,19.4148182 L9.5,19.4148182 C8.67157288,19.4148182 8,18.7432453 8,17.9148182 Z"
                                                        fill="#000000" fill-rule="nonzero"
                                                        transform="translate(12.000000, 10.707409) rotate(-135.000000) translate(-12.000000, -10.707409) ">
                                                    </path>
                                                    <rect fill="#000000" opacity="0.3" x="5" y="20" width="15" height="2"
                                                        rx="1"></rect>
                                                </g>
                                            </svg> </span>
                                    </a>
                                    <a class="btn btn-sm btn-clean btn-icon btns-delete" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="حذف">
                                        <span> 
                                            <svg xmlns="http://www.w3.org/2000/svg"
                                                xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px"
                                                viewBox="0 0 24 24" version="1.1">
                                                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                    <rect x="0" y="0" width="24" height="24"></rect>
                                                    <path
                                                        d="M6,8 L6,20.5 C6,21.3284271 6.67157288,22 7.5,22 L16.5,22 C17.3284271,22 18,21.3284271 18,20.5 L18,8 L6,8 Z"
                                                        fill="#000000" fill-rule="nonzero"></path>
                                                    <path
                                                        d="M14,4.5 L14,4 C14,3.44771525 13.5522847,3 13,3 L11,3 C10.4477153,3 10,3.44771525 10,4 L10,4.5 L5.5,4.5 C5.22385763,4.5 5,4.72385763 5,5 L5,5.5 C5,5.77614237 5.22385763,6 5.5,6 L18.5,6 C18.7761424,6 19,5.77614237 19,5.5 L19,5 C19,4.72385763 18.7761424,4.5 18.5,4.5 L14,4.5 Z"
                                                        fill="#000000" opacity="0.3"></path>
                                                </g>
                                            </svg> 
                                        </span>
                                    </a>
                                    <input type="text" class="value-delete" style="display:none" value="{{$item_user -> id}}" />
                                </td>
                            </tr>
                        @endforeach

                    </tbody>

                </table>
                <!--end: جدول داده ها-->
            </div>
            <div>
                {{ $all_user->links('layouts.others.pagination') }}
            </div>
        </div>
    </div>


    <div class="swal2-container swal2-rtl swal2-center swal2-backdrop-show box-delete" style="display:none" style="overflow-y: auto;">
      <div aria-labelledby="swal2-title" aria-describedby="swal2-html-container" class="swal2-popup swal2-modal swal2-icon-error swal2-show" tabindex="-1" role="dialog" aria-live="assertive" aria-modal="true" style="display: grid;">
            <div class="swal2-icon swal2-warning swal2-icon-show" style="display: flex;"><div class="swal2-icon-content">!</div></div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">آیا مطمئن هستید؟</div>
            <div class="swal2-html-container" style="display: block;margin:0" style="width: 100%;margin: 0;">درصورت حذف امکان بازگردانی جود ندارد!</div>
      <div class="swal2-actions" style="display: flex;margin-bottom: 30px;">
      <div class="swal2-loader"></div>

        <button class="swal2-confirm btn btn-danger btns-delete-cancele" aria-label="" style="display: inline-block;margin:0" >نه کنسل کن</button>
        <div class="swal-button-container">
            <form action="" method="POST" class="form-delete" style="margin:0">
                {{method_field('delete')}}
                {{ csrf_field()}}
                <button class="swal2-confirm btn btn-success" style="margin-top: 0">بله حذف کن</button>
            </form>
        </div>

      </div>
      </div>
      </div>

@endsection
