﻿@extends('layouts/panel/header')
@section('title', 'سفارش ها')
@section('content')

<div class="row g-5 g-xl-10 mb-5 mb-xl-10">
	<div class="col-lg-12">


		<div class="card card-custom table-responsive">
			<div class="card-header flex-wrap ">
				<div class="card-title">
					<h5 class="card-label">
					سفارش ها
					</h5>
				</div>
			</div>
			<div class="card-body pad-top-0">

					

				<!--begin: جدول داده ها-->
				<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
					<thead>
						<tr>
							<th>عکس محصول</th>
							<th>نام محصول</th>
							<th>تعداد</th>
							<th>مبلغ واحد</th>
							<th>مبلغ کل</th>
						</tr>
					</thead>
					<tbody>
						@foreach ($find_factor -> items_factor["AllCarts"] as $item_allCarts)
							<tr>
								<td><img src="{{url("upload/Product")."/". $item_allCarts['image']}}" alt="image" class="p-3" style="width:100px;"></td>
								<td>{{$item_allCarts['name']}}</td>
								<td>{{$item_allCarts['quantity']}} عدد</td>
								<td>{{ number_format($item_allCarts['price']) }} تومان</td>
								<td>{{ number_format($item_allCarts['price'] * $item_allCarts['quantity']) }} تومان</td>
							</tr>
						@endforeach

					</tbody>

				</table>
				<!--end: جدول داده ها-->

			</div>
		</div>
	</div>





	<div class="col-lg-12">
		<div class="card card-custom gutter-b  example-compact">
			<div class="card-header">
				<h3 class="card-title">
					تکمیل سفارش
				</h3>
			</div>
			<!--begin::Form-->
			<form class="form-horizontal" method="POST" action="{{ url('panel/changeOrder'.'/'.$find_factor -> id) }}" enctype="multipart/form-data">
				{{ csrf_field() }}
				<div class="card-body pad-top-0">
					<div class="row">

						<div class="col-lg-4 form-group mb-3">
							<label class="mb-3">انتخاب آدرس</label>
							<!--begin::انتخاب-->
							<select name="address" data-control="select2" data-placeholder="انتخاب آدرس" class="form-select form-select-solid" required>
								<option value="">انتخاب آدرس</option>
								@foreach ($AddressHome as $item_AddressHome)
									<option value="{{$item_AddressHome -> id}}" @if($item_AddressHome -> id == $find_factor -> items_factor["AddressId"]) selected @endif>{{$item_AddressHome -> title}}</option>
								@endforeach
							</select>
							<!--end::انتخاب-->
						</div>

						<div class="col-lg-4 form-group mb-3">
							<label class="mb-3">انتخاب وضعیت سفارش</label>
							<!--begin::انتخاب-->
							<select name="status" data-control="select2" data-placeholder="انتخاب وضعیت سفارش" class="form-select form-select-solid">
								<option value="">انتخاب وضعیت سفارش</option>
								<option value="1" @if($find_factor -> items_factor["StatusSend"] == 1) selected @endif>ارسال شده</option>
								<option value="2" @if($find_factor -> items_factor["StatusSend"] == 2) selected @endif>در دست برسی</option>
								<option value="3" @if($find_factor -> items_factor["StatusSend"] == 3) selected @endif>لغو شده</option>
							</select>
							<!--end::انتخاب-->
						</div>

						<div class="col-lg-4 form-group mb-3">
							<label class="mb-3">کد رهگیری</label>
							<input id="TrackingCode" type="text" class="form-control" name="TrackingCode" value="{{ $find_factor -> items_factor["TrackingCode"] }}" placeholder="کد رهگیری" required>
						</div>     
					</div>


		
            
				</div>
				<div class="card-footer">
					<button class="btn btn-primary mr-2">ثبت</button>
					<a href="{{url('panel/index')}}" class="btn btn-danger">لغو</a>
				</div>
			</form>
			<!--end::Form-->
		</div>
	</div>









</div>






@endsection
