﻿@extends('layouts/panel/header')
@section('title', 'همه تیکت ها')
@section('content')
@php
	use Hekmatinasser\Verta\Verta;
	use App\Models\User;
	use App\Models\panel\pm_ticket;
	use App\Models\panel\department;

@endphp


<div class="col-lg-12">

        <div class="card card-custom gutter-b" style="margin-bottom: 30px;">
            <div class="card-header">
                <div class="card-title">
                    <h5 class="card-label" style="margin-right: 10px">جستجو پیشرفته</h5>
                </div>
            </div>
            <div class="card-body">
                <form class="form-horizontal" method="GET" action="{{ url('panel/searchTicket') }}">
                        <div class="row">

							<div class="col-lg-6 form-group mb-3">
								<label class="mb-3">انتخاب کاربر</label>
								<!--begin::انتخاب-->
								<select name="client" data-control="select2" data-placeholder="انتخاب کاربر" class="form-select form-select-solid">
									<option value="">انتخاب کاربر</option>
									@foreach ($all_client as $item)
										<option value="{{$item -> id}}">{{$item -> name}}</option>
									@endforeach
								</select>
								<!--end::انتخاب-->
							</div>



							<div class="col-lg-6 form-group mb-3">
								<label class="mb-3">انتخاب دپارتمان</label>
								<!--begin::انتخاب-->
								<select name="department" data-control="select2" data-placeholder="انتخاب دپارتمان" class="form-select form-select-solid">
									<option value="">انتخاب دپارتمان</option>
									@foreach ($all_department as $item)
										<option value="{{$item -> id}}">{{$item -> name}}</option>
									@endforeach
								</select>
								<!--end::انتخاب-->
							</div>

							<div class="col-lg-6 form-group mb-3">
								<label class="mb-3">انتخاب اهمیت</label>
								<!--begin::انتخاب-->
								<select name="importance" data-control="select2" data-placeholder="انتخاب اهمیت" class="form-select form-select-solid">
									<option value="">انتخاب اهمیت</option>
									<option value="1" >کم</option>
									<option value="2" >متوسط</option>
									<option value="3" >زیاد</option>
								</select>
								<!--end::انتخاب-->
							</div>


							<div class="col-lg-6 form-group mb-3">
								<label class="mb-3">انتخاب وضعیت</label>
								<!--begin::انتخاب-->
								<select name="status" data-control="select2" data-placeholder="انتخاب وضعیت" class="form-select form-select-solid">
									<option value="">انتخاب وضعیت</option>
									<option value="1" >باز</option>
									<option value="2" >بسته</option>
									<option value="3" >در انتظار پاسخ</option>
									<option value="4" >پاسخ داده شده</option>
									<option value="5" >در حال رسیدگی</option>
									<option value="6" >از طرف ادمین</option>
								</select>
								<!--end::انتخاب-->
							</div>

                            <div class="col-lg-6 form-group mb-3">
                                <label class="mb-3">انتخاب جستجو</label>
                                <!--begin::انتخاب-->
                                <select name="selectvalue" data-control="select2" data-placeholder="انتخاب جستجو" class="form-select form-select-solid">
                                    <option value="">انتخاب جستجو</option>
									<option value="id">شماره تیکت</option>
									<option value="title">موضوع</option>
                                </select>
                                <!--end::انتخاب-->
                            </div>
                            <div class="col-lg-6 form-group mb-3">
                                <label class="mb-3">متن جستجو</label>
                                <input id="name" type="text" class="form-control" name="search"  placeholder="متن جستجو">
                            </div>
                        </div>
                    <div class="card-footer" style="padding: 20px 0px 0px 0px;">
                        <button class="btn btn-primary mr-2">جستجو</button>
                    </div>
                </form>
            </div>
        </div>







	<div class="card card-custom table-responsive">
		<div class="card-header flex-wrap ">
			<div class="card-title">
				<h5 class="card-label">
					همه تیکت ها
				</h5>
			</div>
		</div>
		<div class="card-body pad-top-0">
			<!--begin: جدول داده ها-->
			<table class="table table-row-dashed table-row-gray-200 align-middle gs-0 gy-4">
				<thead>
					<tr>
						<th>شماره تیکت</th>
						<th>نام و نام خانوادگی</th>
						<th>دپارتمان</th>
						<th>موضوع</th>
						<th>اهمیت</th>
						<th>وضعیت</th>
						<th>تاریخ</th>
						<th>عملیات</th>
					</tr>
				</thead>
				<tbody>
					@foreach ($allTicket as $item)
						<tr>
							<td>{{$item->id}} #</td>

							<td>
								@php 
									$client_id = User::find($item -> client_id);
									if($client_id != null){
										echo $client_id -> name;
									}else{
										echo '-';
									}
								@endphp							
							</td>


							<td>
								@php 
									$find_department = department::find($item -> department);
									if($find_department != null){
										echo $find_department -> name;
									}else{
										echo '-';
									}
								@endphp							
							</td>
							<td>{{$item->title}}</td>
							<td>
								@if ($item -> importance == 1)
									کم
								@elseif ($item -> importance == 2)
									متوسط
								@else
									زیاد
								@endif
							</td> 
							<td>
								@if ($item -> status == 1)
									<span class="badge badge-light-success nback">باز</span>
								@elseif ($item -> status == 3)
									<span class="badge badge-light-success nback">در انتظار پاسخ</span>
								@elseif ($item -> status == 4)
									<span class="badge badge-light-info nback">پاسخ داده شده</span>
								@elseif ($item -> status == 5)
									<span class="badge badge-light-warning nback">در حال رسیدگی</span>
								@elseif ($item -> status == 6)
									<span class="badge badge-light-success nback">از طرف ادمین</span>
								@else
									<span class="badge badge-light-danger nback">بسته</span>
								@endif
							</td>
							
							<td>
								{{$item -> created_at}}
							</td>
							<td class="delete-content">
								<a href="{{ url('panel/ticket') . '/' . $item->id }}"
									class="btn btn-sm btn-clean btn-icon mr-2" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-original-title="مشاهده">
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="0" y="0" width="24" height="24"></rect>
                                                <path d="M3.5,21 L20.5,21 C21.3284271,21 22,20.3284271 22,19.5 L22,8.5 C22,7.67157288 21.3284271,7 20.5,7 L10,7 L7.43933983,4.43933983 C7.15803526,4.15803526 6.77650439,4 6.37867966,4 L3.5,4 C2.67157288,4 2,4.67157288 2,5.5 L2,19.5 C2,20.3284271 2.67157288,21 3.5,21 Z" fill="#000000" opacity="0.3"></path>
                                                <path d="M12,13 C10.8954305,13 10,12.1045695 10,11 C10,9.8954305 10.8954305,9 12,9 C13.1045695,9 14,9.8954305 14,11 C14,12.1045695 13.1045695,13 12,13 Z" fill="#000000" opacity="0.3"></path>
                                                <path d="M7.00036205,18.4995035 C7.21569918,15.5165724 9.36772908,14 11.9907452,14 C14.6506758,14 16.8360465,15.4332455 16.9988413,18.5 C17.0053266,18.6221713 16.9988413,19 16.5815,19 C14.5228466,19 11.463736,19 7.4041679,19 C7.26484009,19 6.98863236,18.6619875 7.00036205,18.4995035 Z" fill="#000000" opacity="0.3"></path>
                                            </g>
                                        </svg>
									</span>
								</a>
							</td>
						</tr>
					@endforeach

				</tbody>

			</table>
			<!--end: جدول داده ها-->
		</div>
		<div>
			{{ $allTicket->links('layouts.others.pagination') }}
		</div>
	</div>
</div>

@endsection
